/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util.timeline;

import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.flink.shaded.hadoop2.org.codehaus.jackson.JsonGenerationException;
import org.apache.flink.shaded.hadoop2.org.codehaus.jackson.map.JsonMappingException;
import org.apache.flink.shaded.hadoop2.org.codehaus.jackson.map.ObjectMapper;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.util.VersionInfo;
import org.apache.hadoop.yarn.api.records.timeline.TimelineAbout;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.util.YarnVersionInfo;
import org.apache.hadoop.yarn.webapp.YarnJacksonJaxbJsonProvider;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class TimelineUtils {
    private static ObjectMapper mapper = new ObjectMapper();

    public static String dumpTimelineRecordtoJSON(Object o) throws JsonGenerationException, JsonMappingException, IOException {
        return TimelineUtils.dumpTimelineRecordtoJSON(o, false);
    }

    public static String dumpTimelineRecordtoJSON(Object o, boolean pretty) throws JsonGenerationException, JsonMappingException, IOException {
        if (pretty) {
            return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(o);
        }
        return mapper.writeValueAsString(o);
    }

    public static boolean timelineServiceEnabled(Configuration conf) {
        return conf.getBoolean("yarn.timeline-service.enabled", false);
    }

    public static float getTimelineServiceVersion(Configuration conf) {
        return conf.getFloat("yarn.timeline-service.version", 1.0f);
    }

    public static boolean timelineServiceV1_5Enabled(Configuration conf) {
        return TimelineUtils.timelineServiceEnabled(conf) && Math.abs((double)TimelineUtils.getTimelineServiceVersion(conf) - 1.5) < 1.0E-5;
    }

    public static TimelineAbout createTimelineAbout(String about) {
        TimelineAbout tsInfo = new TimelineAbout(about);
        tsInfo.setHadoopBuildVersion(VersionInfo.getBuildVersion());
        tsInfo.setHadoopVersion(VersionInfo.getVersion());
        tsInfo.setHadoopVersionBuiltOn(VersionInfo.getDate());
        tsInfo.setTimelineServiceBuildVersion(YarnVersionInfo.getBuildVersion());
        tsInfo.setTimelineServiceVersion(YarnVersionInfo.getVersion());
        tsInfo.setTimelineServiceVersionBuiltOn(YarnVersionInfo.getDate());
        return tsInfo;
    }

    public static InetSocketAddress getTimelineTokenServiceAddress(Configuration conf) {
        InetSocketAddress timelineServiceAddr = null;
        timelineServiceAddr = YarnConfiguration.useHttps(conf) ? conf.getSocketAddr("yarn.timeline-service.webapp.https.address", "0.0.0.0:8190", 8190) : conf.getSocketAddr("yarn.timeline-service.webapp.address", "0.0.0.0:8188", 8188);
        return timelineServiceAddr;
    }

    public static Text buildTimelineTokenService(Configuration conf) {
        InetSocketAddress timelineServiceAddr = TimelineUtils.getTimelineTokenServiceAddress(conf);
        return SecurityUtil.buildTokenService(timelineServiceAddr);
    }

    static {
        YarnJacksonJaxbJsonProvider.configObjectMapper(mapper);
    }
}

