/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.shell;

import java.io.IOException;
import java.util.LinkedList;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FsShellPermissions;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.shell.AclCommands;
import org.apache.hadoop.fs.shell.Command;
import org.apache.hadoop.fs.shell.CommandFactory;
import org.apache.hadoop.fs.shell.Concat;
import org.apache.hadoop.fs.shell.CopyCommands;
import org.apache.hadoop.fs.shell.Count;
import org.apache.hadoop.fs.shell.Delete;
import org.apache.hadoop.fs.shell.Display;
import org.apache.hadoop.fs.shell.FsUsage;
import org.apache.hadoop.fs.shell.Head;
import org.apache.hadoop.fs.shell.Ls;
import org.apache.hadoop.fs.shell.Mkdir;
import org.apache.hadoop.fs.shell.MoveCommands;
import org.apache.hadoop.fs.shell.PathData;
import org.apache.hadoop.fs.shell.SetReplication;
import org.apache.hadoop.fs.shell.SnapshotCommands;
import org.apache.hadoop.fs.shell.Stat;
import org.apache.hadoop.fs.shell.Tail;
import org.apache.hadoop.fs.shell.Test;
import org.apache.hadoop.fs.shell.TouchCommands;
import org.apache.hadoop.fs.shell.Truncate;
import org.apache.hadoop.fs.shell.XAttrCommands;
import org.apache.hadoop.fs.shell.find.Find;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public abstract class FsCommand
extends Command {
    public static void registerCommands(CommandFactory factory2) {
        factory2.registerCommands(AclCommands.class);
        factory2.registerCommands(CopyCommands.class);
        factory2.registerCommands(Count.class);
        factory2.registerCommands(Delete.class);
        factory2.registerCommands(Display.class);
        factory2.registerCommands(Find.class);
        factory2.registerCommands(FsShellPermissions.class);
        factory2.registerCommands(FsUsage.class);
        factory2.registerCommands(Ls.class);
        factory2.registerCommands(Mkdir.class);
        factory2.registerCommands(MoveCommands.class);
        factory2.registerCommands(SetReplication.class);
        factory2.registerCommands(Stat.class);
        factory2.registerCommands(Tail.class);
        factory2.registerCommands(Head.class);
        factory2.registerCommands(Test.class);
        factory2.registerCommands(TouchCommands.class);
        factory2.registerCommands(Truncate.class);
        factory2.registerCommands(SnapshotCommands.class);
        factory2.registerCommands(XAttrCommands.class);
        factory2.registerCommands(Concat.class);
    }

    protected FsCommand() {
    }

    protected FsCommand(Configuration conf) {
        super(conf);
    }

    @Override
    public String getCommandName() {
        return this.getName();
    }

    @Override
    protected void run(Path path) throws IOException {
        throw new RuntimeException("not supposed to get here");
    }

    @Override
    @Deprecated
    public int runAll() {
        return this.run(this.args);
    }

    @Override
    protected void processRawArguments(LinkedList<String> args2) throws IOException {
        LinkedList<PathData> expendedArgs = this.expandArguments(args2);
        boolean displayWarnings = this.getConf().getBoolean("hadoop.shell.missing.defaultFs.warning", false);
        if (displayWarnings) {
            boolean missingDefaultFs;
            String defaultFs = this.getConf().get("fs.defaultFS");
            boolean bl = missingDefaultFs = defaultFs == null || defaultFs.equals("file:///");
            if (missingDefaultFs) {
                this.err.printf("Warning: fs.defaultFS is not set when running \"%s\" command.%n", this.getCommandName());
            }
        }
        this.processArguments(expendedArgs);
    }
}

