/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.statistics.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsStore;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsStoreBuilder;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsStoreImpl;

final class IOStatisticsStoreBuilderImpl
implements IOStatisticsStoreBuilder {
    private final List<String> counters = new ArrayList<String>();
    private final List<String> gauges = new ArrayList<String>();
    private final List<String> minimums = new ArrayList<String>();
    private final List<String> maximums = new ArrayList<String>();
    private final List<String> meanStatistics = new ArrayList<String>();

    IOStatisticsStoreBuilderImpl() {
    }

    @Override
    public IOStatisticsStoreBuilderImpl withCounters(String ... keys2) {
        this.counters.addAll(Arrays.asList(keys2));
        return this;
    }

    @Override
    public IOStatisticsStoreBuilderImpl withGauges(String ... keys2) {
        this.gauges.addAll(Arrays.asList(keys2));
        return this;
    }

    @Override
    public IOStatisticsStoreBuilderImpl withMaximums(String ... keys2) {
        this.maximums.addAll(Arrays.asList(keys2));
        return this;
    }

    @Override
    public IOStatisticsStoreBuilderImpl withMinimums(String ... keys2) {
        this.minimums.addAll(Arrays.asList(keys2));
        return this;
    }

    @Override
    public IOStatisticsStoreBuilderImpl withMeanStatistics(String ... keys2) {
        this.meanStatistics.addAll(Arrays.asList(keys2));
        return this;
    }

    @Override
    public IOStatisticsStoreBuilderImpl withDurationTracking(String ... prefixes) {
        for (String p : prefixes) {
            this.withCounters(p, p + ".failures");
            this.withMinimums(p + ".min", p + ".failures" + ".min");
            this.withMaximums(p + ".max", p + ".failures" + ".max");
            this.withMeanStatistics(p + ".mean", p + ".failures" + ".mean");
        }
        return this;
    }

    @Override
    public IOStatisticsStore build() {
        return new IOStatisticsStoreImpl(this.counters, this.gauges, this.minimums, this.maximums, this.meanStatistics);
    }
}

