/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.security.NetgroupCache;
import org.apache.hadoop.security.ShellBasedUnixGroupsMapping;
import org.apache.hadoop.util.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
@InterfaceStability.Evolving
public class ShellBasedUnixGroupsNetgroupMapping
extends ShellBasedUnixGroupsMapping {
    private static final Logger LOG = LoggerFactory.getLogger(ShellBasedUnixGroupsNetgroupMapping.class);

    @Override
    public List<String> getGroups(String user) throws IOException {
        LinkedList<String> groups2 = new LinkedList<String>(super.getGroups(user));
        NetgroupCache.getNetgroups(user, groups2);
        return groups2;
    }

    @Override
    public void cacheGroupsRefresh() throws IOException {
        List<String> groups2 = NetgroupCache.getNetgroupNames();
        NetgroupCache.clear();
        this.cacheGroupsAdd(groups2);
    }

    @Override
    public void cacheGroupsAdd(List<String> groups2) throws IOException {
        for (String group : groups2) {
            if (group.length() == 0 || group.charAt(0) != '@' || NetgroupCache.isCached(group)) continue;
            NetgroupCache.add(group, this.getUsersForNetgroup(group));
        }
    }

    protected List<String> getUsersForNetgroup(String netgroup) throws IOException {
        String[] userInfos;
        LinkedList<String> users = new LinkedList<String>();
        String usersRaw = this.execShellGetUserForNetgroup(netgroup);
        usersRaw = usersRaw.replaceAll(" +", "");
        usersRaw = usersRaw.replaceFirst(netgroup.replaceFirst("@", "") + "[()]+", "");
        for (String userInfo : userInfos = usersRaw.split("[()]+")) {
            String user = userInfo.replaceFirst("[^,]*,", "");
            user = user.replaceFirst(",.*$", "");
            users.add(user);
        }
        return users;
    }

    protected String execShellGetUserForNetgroup(String netgroup) throws IOException {
        String result = "";
        try {
            result = Shell.execCommand(Shell.getUsersForNetgroupCommand(netgroup.substring(1)));
        }
        catch (Shell.ExitCodeException e) {
            LOG.warn("error getting users for netgroup " + netgroup, (Throwable)e);
        }
        return result;
    }
}

