/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.fluss.fs.gs;

import org.apache.fluss.fs.FileSystem;
import org.apache.fluss.fs.hdfs.HadoopFileSystem;
import org.apache.fluss.fs.token.ObtainedSecurityToken;

import org.apache.hadoop.conf.Configuration;

import java.io.IOException;

// TODO: implement obtainSecurityToken to enable clients access the Google File System
//  through the FileSystem security token receiver API.
/**
 * Implementation of the Fluss {@link FileSystem} interface for Google Cloud Storage. This class
 * implements the common behavior implemented directly by Fluss and delegates common calls to an
 * implementation of Hadoop's filesystem abstraction.
 */
public class GSFileSystem extends HadoopFileSystem {

    private final String scheme;
    private final Configuration conf;

    /**
     * Creates a GSFileSystem based on the given Hadoop Google Cloud Storage file system. The given
     * Hadoop file system object is expected to be initialized already.
     *
     * <p>This constructor additionally configures the entropy injection for the file system.
     *
     * @param hadoopGSFileSystem The Hadoop FileSystem that will be used under the hood.
     */
    public GSFileSystem(
            String scheme, org.apache.hadoop.fs.FileSystem hadoopGSFileSystem, Configuration conf) {
        super(hadoopGSFileSystem);
        this.scheme = scheme;
        this.conf = conf;
    }

    @Override
    public ObtainedSecurityToken obtainSecurityToken() throws IOException {
        throw new UnsupportedOperationException("Not impl.");
    }
}
