/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.variants;

import java.nio.ByteBuffer;
import org.apache.iceberg.variants.VariantData;
import org.apache.iceberg.variants.VariantMetadata;
import org.apache.iceberg.variants.VariantUtil;
import org.apache.iceberg.variants.VariantValue;

public interface Variant {
    public static final byte VARIANT_SPEC_VERSION = 1;

    public VariantMetadata metadata();

    public VariantValue value();

    public static Variant of(VariantMetadata metadata, VariantValue value) {
        return new VariantData(metadata, value);
    }

    public static Variant from(ByteBuffer buffer) {
        VariantMetadata metadata = VariantMetadata.from(buffer);
        ByteBuffer valueBuffer = VariantUtil.slice(buffer, metadata.sizeInBytes(), buffer.remaining() - metadata.sizeInBytes());
        VariantValue value = VariantValue.from(metadata, valueBuffer);
        return Variant.of(metadata, value);
    }

    public static String toString(Variant variant) {
        return "Variant(metadata=" + String.valueOf(variant.metadata()) + ", value=" + String.valueOf(variant.value()) + ")";
    }
}

