/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime;

import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.annotations.ConfigDocSection;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import io.quarkus.vertx.http.runtime.AccessLogConfig;
import io.quarkus.vertx.http.runtime.AuthRuntimeConfig;
import io.quarkus.vertx.http.runtime.BodyConfig;
import io.quarkus.vertx.http.runtime.FilterConfig;
import io.quarkus.vertx.http.runtime.HeaderConfig;
import io.quarkus.vertx.http.runtime.ProxyConfig;
import io.quarkus.vertx.http.runtime.SameSiteCookieConfig;
import io.quarkus.vertx.http.runtime.ServerLimitsConfig;
import io.quarkus.vertx.http.runtime.ServerSslConfig;
import io.quarkus.vertx.http.runtime.StaticResourcesConfig;
import io.quarkus.vertx.http.runtime.TrafficShapingConfig;
import io.quarkus.vertx.http.runtime.WebsocketServerConfig;
import io.quarkus.vertx.http.runtime.cors.CORSConfig;
import io.smallrye.config.ConfigMapping;
import io.smallrye.config.WithDefault;
import io.smallrye.config.WithName;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;

@ConfigMapping(prefix="quarkus.http")
@ConfigRoot(phase=ConfigPhase.RUN_TIME)
public interface VertxHttpConfig {
    @ConfigDocSection(generated=true)
    public AuthRuntimeConfig auth();

    @WithDefault(value="8080")
    public int port();

    @WithDefault(value="8081")
    public int testPort();

    public String host();

    public Optional<String> testHost();

    @WithDefault(value="true")
    public boolean hostEnabled();

    @WithDefault(value="8443")
    public int sslPort();

    @WithDefault(value="8444")
    public int testSslPort();

    public Optional<Boolean> testSslEnabled();

    public Optional<InsecureRequests> insecureRequests();

    @WithDefault(value="true")
    public boolean http2();

    @WithDefault(value="true")
    public boolean http2PushEnabled();

    @ConfigDocSection(generated=true)
    public CORSConfig cors();

    public ServerSslConfig ssl();

    public Optional<String> tlsConfigurationName();

    @ConfigDocSection(generated=true)
    public StaticResourcesConfig staticResources();

    @WithName(value="handle-100-continue-automatically")
    @WithDefault(value="false")
    public boolean handle100ContinueAutomatically();

    public OptionalInt ioThreads();

    @ConfigDocSection(generated=true)
    public ServerLimitsConfig limits();

    @WithDefault(value="30M")
    public Duration idleTimeout();

    @WithDefault(value="60s")
    public Duration readTimeout();

    public BodyConfig body();

    @WithName(value="auth.session.encryption-key")
    public Optional<String> encryptionKey();

    @WithDefault(value="false")
    public boolean soReusePort();

    @WithDefault(value="false")
    public boolean tcpQuickAck();

    @WithDefault(value="false")
    public boolean tcpCork();

    @WithDefault(value="false")
    public boolean tcpFastOpen();

    @WithDefault(value="-1")
    public int acceptBacklog();

    public OptionalInt initialWindowSize();

    @WithDefault(value="/var/run/io.quarkus.app.socket")
    public String domainSocket();

    @WithDefault(value="false")
    public boolean domainSocketEnabled();

    @WithDefault(value="false")
    public boolean recordRequestStartTime();

    @ConfigDocSection(generated=true)
    public AccessLogConfig accessLog();

    @ConfigDocSection
    public TrafficShapingConfig trafficShaping();

    public Map<String, SameSiteCookieConfig> sameSiteCookie();

    public Optional<PayloadHint> unhandledErrorContentTypeDefault();

    @ConfigDocSection(generated=true)
    public Map<String, HeaderConfig> header();

    @ConfigDocSection(generated=true)
    public Map<String, FilterConfig> filter();

    @ConfigDocSection
    public ProxyConfig proxy();

    @ConfigDocSection
    public WebsocketServerConfig websocketServer();

    default public int determinePort(LaunchMode launchMode) {
        return launchMode == LaunchMode.TEST ? this.testPort() : this.port();
    }

    default public int determineSslPort(LaunchMode launchMode) {
        return launchMode == LaunchMode.TEST ? this.testSslPort() : this.sslPort();
    }

    public static enum PayloadHint {
        JSON,
        HTML,
        TEXT;

    }

    public static enum InsecureRequests {
        ENABLED,
        REDIRECT,
        DISABLED;

    }
}

