/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.entity;

import com.google.common.base.Preconditions;
import jakarta.annotation.Nullable;
import org.apache.polaris.core.admin.model.PrincipalRole;
import org.apache.polaris.core.entity.PolarisBaseEntity;
import org.apache.polaris.core.entity.PolarisEntity;
import org.apache.polaris.core.entity.PolarisEntityConstants;
import org.apache.polaris.core.entity.PolarisEntitySubType;
import org.apache.polaris.core.entity.PolarisEntityType;
import org.apache.polaris.core.entity.table.federated.FederatedEntities;

public class PrincipalRoleEntity
extends PolarisEntity {
    public PrincipalRoleEntity(PolarisBaseEntity sourceEntity) {
        super(sourceEntity);
        Preconditions.checkState((this.getType() == PolarisEntityType.PRINCIPAL_ROLE ? 1 : 0) != 0, (String)"Invalid entity type: %s", (Object)((Object)this.getType()));
        Preconditions.checkState((this.getSubType() == PolarisEntitySubType.NULL_SUBTYPE ? 1 : 0) != 0, (String)"Invalid entity sub type: %s", (Object)((Object)this.getSubType()));
    }

    @Nullable
    public static PrincipalRoleEntity of(@Nullable PolarisBaseEntity sourceEntity) {
        if (sourceEntity != null) {
            return new PrincipalRoleEntity(sourceEntity);
        }
        return null;
    }

    public static PrincipalRoleEntity fromPrincipalRole(PrincipalRole principalRole) {
        return ((Builder)((Builder)new Builder().setName(principalRole.getName())).setFederated(principalRole.getFederated()).setProperties(principalRole.getProperties())).build();
    }

    public PrincipalRole asPrincipalRole() {
        return new PrincipalRole(this.getName(), Boolean.valueOf(FederatedEntities.isFederated(this)), this.getPropertiesAsMap(), Long.valueOf(this.getCreateTimestamp()), Long.valueOf(this.getLastUpdateTimestamp()), Integer.valueOf(this.getEntityVersion()));
    }

    public static class Builder
    extends PolarisEntity.BaseBuilder<PrincipalRoleEntity, Builder> {
        public Builder() {
            this.setType(PolarisEntityType.PRINCIPAL_ROLE);
            this.setCatalogId(PolarisEntityConstants.getNullId());
            this.setParentId(PolarisEntityConstants.getRootEntityId());
        }

        public Builder(PrincipalRoleEntity original) {
            super(original);
        }

        public Builder setFederated(Boolean isFederated) {
            if (isFederated != null && isFederated.booleanValue()) {
                this.internalProperties.put("federated", "true");
            } else {
                this.internalProperties.remove("federated");
            }
            return this;
        }

        @Override
        public PrincipalRoleEntity build() {
            return new PrincipalRoleEntity(this.buildBase());
        }
    }
}

