/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.core.timeout;

import io.smallrye.faulttolerance.core.Completer;
import io.smallrye.faulttolerance.core.FaultToleranceContext;
import io.smallrye.faulttolerance.core.FaultToleranceStrategy;
import io.smallrye.faulttolerance.core.Future;
import io.smallrye.faulttolerance.core.timeout.FutureTimeoutNotification;
import io.smallrye.faulttolerance.core.timeout.TimeoutEvents;
import io.smallrye.faulttolerance.core.timeout.TimeoutExecution;
import io.smallrye.faulttolerance.core.timeout.TimeoutLogger;
import io.smallrye.faulttolerance.core.timer.Timer;
import io.smallrye.faulttolerance.core.timer.TimerTask;
import io.smallrye.faulttolerance.core.util.Preconditions;
import java.util.concurrent.Executor;
import org.eclipse.microprofile.faulttolerance.exceptions.TimeoutException;

public class Timeout<V>
implements FaultToleranceStrategy<V> {
    private final FaultToleranceStrategy<V> delegate;
    private final String description;
    private final long timeoutInMillis;
    private final Timer timer;

    public Timeout(FaultToleranceStrategy<V> delegate, String description, long timeoutInMillis, Timer timer) {
        this.delegate = Preconditions.checkNotNull(delegate, "Timeout delegate must be set");
        this.description = Preconditions.checkNotNull(description, "Timeout description must be set");
        this.timeoutInMillis = Preconditions.check(timeoutInMillis, timeoutInMillis > 0L, "Timeout must be > 0");
        this.timer = Preconditions.checkNotNull(timer, "Timer must be set");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<V> apply(FaultToleranceContext<V> ctx) {
        TimeoutLogger.LOG.trace("Timeout started");
        try {
            Future<Object> originalResult;
            Completer result = Completer.create();
            ctx.fireEvent(TimeoutEvents.Started.INSTANCE);
            FutureTimeoutNotification notification = ctx.remove(FutureTimeoutNotification.class);
            Thread executingThread = ctx.isSync() ? Thread.currentThread() : null;
            TimeoutExecution execution = new TimeoutExecution(executingThread, () -> {
                TimeoutLogger.LOG.debugf("%s invocation timed out (%d ms)", this.description, this.timeoutInMillis);
                ctx.fireEvent(TimeoutEvents.Finished.TIMED_OUT);
                TimeoutException timeout = new TimeoutException(this.description + " timed out");
                if (notification != null) {
                    notification.accept(timeout);
                }
                result.completeWithError((Throwable)timeout);
            });
            TimerTask task = this.timer.schedule(this.timeoutInMillis, execution::timeoutAndInterrupt, ctx.get(Executor.class));
            try {
                originalResult = this.delegate.apply(ctx);
            }
            catch (Exception e) {
                originalResult = Future.ofError(e);
            }
            originalResult.then((value, error) -> {
                execution.finish(task::cancel);
                if (ctx.isSync() && Thread.interrupted()) {
                    error = new InterruptedException();
                }
                if (!execution.hasTimedOut()) {
                    if (error == null) {
                        ctx.fireEvent(TimeoutEvents.Finished.NORMALLY);
                        result.complete(value);
                    } else {
                        ctx.fireEvent(TimeoutEvents.Finished.NORMALLY);
                        result.completeWithError((Throwable)error);
                    }
                }
            });
            Future future = result.future();
            return future;
        }
        finally {
            TimeoutLogger.LOG.trace("Timeout finished");
        }
    }
}

