/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.dboe.storage.prefixes;

import java.util.Map;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.jena.dboe.storage.prefixes.StoragePrefixMap;
import org.apache.jena.riot.system.PrefixLib;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.PrefixMapBase;
import org.apache.jena.riot.system.Prefixes;

public class PrefixMapOverStorage
extends PrefixMapBase {
    private final StoragePrefixMap prefixes;

    protected StoragePrefixMap spm() {
        return this.prefixes;
    }

    public PrefixMapOverStorage(StoragePrefixMap storage) {
        this.prefixes = storage;
    }

    public Map<String, String> getMapping() {
        return this.getMappingCopy();
    }

    public Map<String, String> getMappingCopy() {
        return this.spm().stream().collect(Collectors.toMap(e -> e.getPrefix(), e -> e.getUri()));
    }

    public void add(String prefix, String iriString) {
        prefix = PrefixLib.canonicalPrefix((String)prefix);
        this.spm().put(prefix, iriString);
    }

    public void delete(String prefix) {
        prefix = PrefixLib.canonicalPrefix((String)prefix);
        this.spm().remove(prefix);
    }

    public void forEach(BiConsumer<String, String> action) {
        this.spm().forEach((? super T entry) -> action.accept(entry.getPrefix(), entry.getUri()));
    }

    public void clear() {
        this.spm().clear();
    }

    public boolean isEmpty() {
        return this.spm().isEmpty();
    }

    public int size() {
        return this.spm().size();
    }

    public String get(String prefix) {
        prefix = PrefixLib.canonicalPrefix((String)prefix);
        return this.spm().get(prefix);
    }

    public boolean containsPrefix(String prefix) {
        prefix = PrefixLib.canonicalPrefix((String)prefix);
        return this.spm().containsPrefix(prefix);
    }

    public String toString() {
        return Prefixes.toString((PrefixMap)this);
    }
}

