/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.authc;

import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.MergableAuthenticationInfo;
import org.apache.shiro.authc.SaltedAuthenticationInfo;
import org.apache.shiro.lang.util.ByteSource;
import org.apache.shiro.lang.util.SimpleByteSource;
import org.apache.shiro.subject.MutablePrincipalCollection;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.SimplePrincipalCollection;

public class SimpleAuthenticationInfo
implements MergableAuthenticationInfo,
SaltedAuthenticationInfo {
    private static final long serialVersionUID = 5390456512469696779L;
    protected PrincipalCollection principals;
    protected Object credentials;
    protected ByteSource credentialsSalt = SimpleByteSource.empty();

    public SimpleAuthenticationInfo() {
    }

    public SimpleAuthenticationInfo(Object principal, Object credentials, String realmName) {
        this.principals = new SimplePrincipalCollection(principal, realmName);
        this.credentials = credentials;
    }

    public SimpleAuthenticationInfo(Object principal, Object hashedCredentials, ByteSource credentialsSalt, String realmName) {
        this.principals = new SimplePrincipalCollection(principal, realmName);
        this.credentials = hashedCredentials;
        this.credentialsSalt = credentialsSalt;
    }

    public SimpleAuthenticationInfo(PrincipalCollection principals, Object credentials) {
        this.principals = new SimplePrincipalCollection(principals);
        this.credentials = credentials;
    }

    public SimpleAuthenticationInfo(PrincipalCollection principals, Object hashedCredentials, ByteSource credentialsSalt) {
        this.principals = new SimplePrincipalCollection(principals);
        this.credentials = hashedCredentials;
        this.credentialsSalt = credentialsSalt;
    }

    @Override
    public PrincipalCollection getPrincipals() {
        return this.principals;
    }

    public void setPrincipals(PrincipalCollection principals) {
        this.principals = principals;
    }

    @Override
    public Object getCredentials() {
        return this.credentials;
    }

    public void setCredentials(Object credentials) {
        this.credentials = credentials;
    }

    @Override
    public ByteSource getCredentialsSalt() {
        return this.credentialsSalt;
    }

    public void setCredentialsSalt(ByteSource salt) {
        this.credentialsSalt = salt;
    }

    @Override
    public void merge(AuthenticationInfo info) {
        if (info == null || info.getPrincipals() == null || info.getPrincipals().isEmpty()) {
            return;
        }
        if (this.principals == null) {
            this.principals = info.getPrincipals();
        } else {
            if (!(this.principals instanceof MutablePrincipalCollection)) {
                this.principals = new SimplePrincipalCollection(this.principals);
            }
            ((MutablePrincipalCollection)this.principals).addAll(info.getPrincipals());
        }
        if (this.credentialsSalt == null && info instanceof SaltedAuthenticationInfo) {
            this.credentialsSalt = ((SaltedAuthenticationInfo)info).getCredentialsSalt();
        }
        Object thisCredentials = this.getCredentials();
        Object otherCredentials = info.getCredentials();
        if (otherCredentials == null) {
            return;
        }
        if (thisCredentials == null) {
            this.credentials = otherCredentials;
            return;
        }
        if (!(thisCredentials instanceof Collection)) {
            HashSet<Object> newSet = new HashSet<Object>();
            newSet.add(thisCredentials);
            this.setCredentials(newSet);
        }
        Collection credentialCollection = (Collection)this.getCredentials();
        if (otherCredentials instanceof Collection) {
            credentialCollection.addAll((Collection)otherCredentials);
        } else {
            credentialCollection.add(otherCredentials);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SimpleAuthenticationInfo)) {
            return false;
        }
        SimpleAuthenticationInfo that = (SimpleAuthenticationInfo)o;
        return Objects.equals(this.principals, that.principals);
    }

    public int hashCode() {
        return this.principals != null ? this.principals.hashCode() : 0;
    }

    public String toString() {
        return this.principals.toString();
    }
}

