/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.assertions;

import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.apache.juneau.assertions.AssertionPredicate;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.cp.Messages;

public class AssertionPredicates {
    private static final Function<Object, String> TYPENAME = Utils::cn;
    private static final Messages MESSAGES = Messages.of(AssertionPredicates.class, (String)"Messages");
    private static final String MSG_valueWasNull = MESSAGES.getString("valueWasNull");
    private static final String MSG_valueWasNotNull = MESSAGES.getString("valueWasNotNull");
    private static final String MSG_valueDidNotMatchExpected = MESSAGES.getString("valueDidNotMatchExpected");
    private static final String MSG_valueDidNotContainExpected = MESSAGES.getString("valueDidNotContainExpected");
    private static final String MSG_valueUnexpectedlyMatched = MESSAGES.getString("valueUnexpectedlyMatched");
    private static final String MSG_valueWasNotExpectedType = MESSAGES.getString("valueWasNotExpectedType");
    private static final String MSG_valueDidNotMatchPattern = MESSAGES.getString("valueDidNotMatchPattern");

    @SafeVarargs
    public static final <T> AssertionPredicate<T> and(Predicate<T> ... predicates) {
        return new AssertionPredicate.And<T>(predicates);
    }

    public static final <T> AssertionPredicate<T> any() {
        return AssertionPredicates.test(x -> true, null, new Object[0]);
    }

    public static final <T> AssertionPredicate<T> contains(String value) {
        return AssertionPredicates.test(x -> StringUtils.contains((String)Utils.s((Object)x), (String)value), MSG_valueDidNotContainExpected, value, AssertionPredicate.VALUE);
    }

    public static final <T> AssertionPredicate<T> eq(Object value) {
        return AssertionPredicates.test(x -> Objects.equals(x, value), MSG_valueDidNotMatchExpected, value, AssertionPredicate.VALUE);
    }

    public static final <T> AssertionPredicate<T> eq(String value) {
        return AssertionPredicates.test(x -> Objects.equals(Utils.s((Object)x), value), MSG_valueDidNotMatchExpected, value, AssertionPredicate.VALUE);
    }

    public static final <T> AssertionPredicate<T> eqic(String value) {
        return AssertionPredicates.test(x -> Utils.eqic((String)Utils.s((Object)x), (String)value), MSG_valueDidNotMatchExpected, value, AssertionPredicate.VALUE);
    }

    public static final <T> AssertionPredicate<T> exactType(Class<?> type) {
        AssertionUtils.assertArgNotNull((String)"type", type);
        return AssertionPredicates.test(x -> x != null && x.getClass().equals(type), MSG_valueWasNotExpectedType, Utils.cn(type), TYPENAME);
    }

    public static final <T> AssertionPredicate<T> isNull() {
        return AssertionPredicates.test(x -> x == null, MSG_valueWasNotNull, new Object[0]);
    }

    public static final <T> AssertionPredicate<T> match(String value) {
        AssertionUtils.assertArgNotNull((String)"value", (Object)value);
        Pattern p = StringUtils.getMatchPattern((String)value);
        return AssertionPredicates.test(x -> x != null && p.matcher(Utils.s((Object)x)).matches(), MSG_valueDidNotMatchPattern, value, AssertionPredicate.VALUE);
    }

    public static final <T> AssertionPredicate<T> ne(Object value) {
        return AssertionPredicates.test(x -> !Objects.equals(x, value), MSG_valueUnexpectedlyMatched, AssertionPredicate.VALUE);
    }

    public static final <T> AssertionPredicate<T> ne(String value) {
        return AssertionPredicates.test(x -> !Objects.equals(Utils.s((Object)x), value), MSG_valueUnexpectedlyMatched, AssertionPredicate.VALUE);
    }

    public static final <T> AssertionPredicate<T> not(Predicate<T> predicate) {
        return new AssertionPredicate.Not<T>(predicate);
    }

    public static final <T> AssertionPredicate<T> notNull() {
        return AssertionPredicates.test(x -> x != null, MSG_valueWasNull, new Object[0]);
    }

    @SafeVarargs
    public static final <T> AssertionPredicate<T> or(Predicate<T> ... predicates) {
        return new AssertionPredicate.Or<T>(predicates);
    }

    public static final <T> AssertionPredicate<T> regex(Pattern value) {
        AssertionUtils.assertArgNotNull((String)"value", (Object)value);
        return AssertionPredicates.test(x -> x != null && value.matcher(Utils.s((Object)x)).matches(), MSG_valueDidNotMatchPattern, value.pattern(), AssertionPredicate.VALUE);
    }

    public static final <T> AssertionPredicate<T> regex(String expression) {
        AssertionUtils.assertArgNotNull((String)"expression", (Object)expression);
        Pattern p = Pattern.compile(expression);
        return AssertionPredicates.test(x -> x != null && p.matcher(Utils.s((Object)x)).matches(), MSG_valueDidNotMatchPattern, expression, AssertionPredicate.VALUE);
    }

    public static final <T> AssertionPredicate<T> regex(String expression, int flags) {
        AssertionUtils.assertArgNotNull((String)"expression", (Object)expression);
        Pattern p = Pattern.compile(expression, flags);
        return AssertionPredicates.test(x -> x != null && p.matcher(Utils.s((Object)x)).matches(), MSG_valueDidNotMatchPattern, expression, AssertionPredicate.VALUE);
    }

    public static final <T> AssertionPredicate<T> test(Predicate<T> predicate) {
        return new AssertionPredicate<T>(predicate, null, new Object[0]);
    }

    public static final <T> AssertionPredicate<T> test(Predicate<T> predicate, String msg, Object ... args) {
        return new AssertionPredicate<T>(predicate, msg, args);
    }

    public static final <T> AssertionPredicate<T> type(Class<?> type) {
        AssertionUtils.assertArgNotNull((String)"type", type);
        return AssertionPredicates.test(x -> x != null && type.isAssignableFrom(x.getClass()), MSG_valueWasNotExpectedType, Utils.cn(type), TYPENAME);
    }

    protected AssertionPredicates() {
    }
}

