/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.ssh.keygenerator;

import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import org.apache.sshd.common.cipher.ECCurves;
import org.apache.sshd.common.util.security.SecurityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenSSHKeyPairGenerator {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private int keySize;
    private String algorithm;

    public OpenSSHKeyPairGenerator(String algorithm, int keySize) {
        this.algorithm = algorithm;
        this.keySize = keySize;
    }

    public KeyPair generate() throws GeneralSecurityException {
        KeyPairGenerator generator = SecurityUtils.getKeyPairGenerator((String)this.algorithm);
        if (this.keySize != 0) {
            generator.initialize(this.keySize);
            this.log.info("generateKeyPair(" + this.algorithm + ") generating host key - size=" + this.keySize);
        } else if ("EC".equals(this.algorithm)) {
            int numCurves = ECCurves.SORTED_KEY_SIZE.size();
            ECCurves curve = (ECCurves)ECCurves.SORTED_KEY_SIZE.get(numCurves - 1);
            generator.initialize(curve.getParameters());
        }
        return generator.generateKeyPair();
    }
}

