/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.processor;

import java.io.OutputStream;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Traceable;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.RouteIdAware;
import org.apache.camel.support.AsyncProcessorSupport;
import org.apache.camel.support.builder.OutputStreamBuilder;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.ObjectHelper;

public class MarshalProcessor
extends AsyncProcessorSupport
implements Traceable,
CamelContextAware,
IdAware,
RouteIdAware {
    private String id;
    private String routeId;
    private CamelContext camelContext;
    private final DataFormat dataFormat;

    public MarshalProcessor(DataFormat dataFormat) {
        this.dataFormat = dataFormat;
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        ObjectHelper.notNull((Object)this.dataFormat, (String)"dataFormat");
        OutputStreamBuilder osb = OutputStreamBuilder.withExchange(exchange);
        Message in = exchange.getIn();
        Object body = in.getBody();
        Message out = exchange.getOut();
        out.copyFrom(in);
        try {
            this.dataFormat.marshal(exchange, body, (OutputStream)osb);
            out.setBody(osb.build());
        }
        catch (Throwable e) {
            exchange.setOut(null);
            exchange.setException(e);
        }
        callback.done(true);
        return true;
    }

    public String toString() {
        return "Marshal[" + this.dataFormat + "]";
    }

    public String getTraceLabel() {
        return "marshal[" + this.dataFormat + "]";
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getRouteId() {
        return this.routeId;
    }

    public void setRouteId(String routeId) {
        this.routeId = routeId;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    protected void doStart() throws Exception {
        if (this.dataFormat instanceof CamelContextAware) {
            ((CamelContextAware)this.dataFormat).setCamelContext(this.camelContext);
        }
        this.getCamelContext().addService((Object)this.dataFormat, false, true);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopService((Object)this.dataFormat);
        this.getCamelContext().removeService((Object)this.dataFormat);
    }
}

