/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.jdbc.hive.strategy;

import java.lang.reflect.Constructor;
import org.apache.kyuubi.jdbc.hive.strategy.ServerSelectStrategy;
import org.apache.kyuubi.jdbc.hive.strategy.zk.PollingSelectStrategy;
import org.apache.kyuubi.jdbc.hive.strategy.zk.RandomSelectStrategy;

public class ServerSelectStrategyFactory {
    public static ServerSelectStrategy createStrategy(String strategyName) {
        try {
            switch (strategyName) {
                case "polling": {
                    return new PollingSelectStrategy();
                }
                case "random": {
                    return new RandomSelectStrategy();
                }
            }
            Class<?> clazz = Class.forName(strategyName);
            if (ServerSelectStrategy.class.isAssignableFrom(clazz)) {
                Constructor<ServerSelectStrategy> constructor = clazz.asSubclass(ServerSelectStrategy.class).getConstructor(new Class[0]);
                return constructor.newInstance(new Object[0]);
            }
            throw new ClassNotFoundException("The loaded class does not implement ServerSelectStrategy");
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to init server select strategy", e);
        }
    }
}

