--
-- Licensed to the Apache Software Foundation (ASF) under one or more
-- contributor license agreements.  See the NOTICE file distributed with
-- this work for additional information regarding copyright ownership.
-- The ASF licenses this file to You under the Apache License, Version 2.0
-- (the "License"); you may not use this file except in compliance with
-- the License.  You may obtain a copy of the License at
--
--    http://www.apache.org/licenses/LICENSE-2.0
--
-- Unless required by applicable law or agreed to in writing, software
-- distributed under the License is distributed on an "AS IS" BASIS,
-- WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
-- See the License for the specific language governing permissions and
-- limitations under the License.
--
-- q15 --
select
  ca_zip,
  sum(cs_sales_price)
from
  catalog_sales,
  customer,
  customer_address,
  date_dim
where
  cs_bill_customer_sk = c_customer_sk
  and c_current_addr_sk = ca_address_sk
  and (
    substr(ca_zip, 1, 5) in (
      '85669',
      '86197',
      '88274',
      '83405',
      '86475',
      '85392',
      '85460',
      '80348',
      '81792'
    )
    or ca_state in ('CA', 'WA', 'GA')
    or cs_sales_price > 500
  )
  and cs_sold_date_sk = d_date_sk
  and d_qoy = 2
  and d_year = 2000
group by
  ca_zip
order by
  ca_zip
limit
  100;
