/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.ctl.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.kyuubi.KyuubiException;
import org.apache.kyuubi.KyuubiException$;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.ctl.opt.CliConfig;
import org.apache.kyuubi.ha.client.DiscoveryClient;
import org.apache.kyuubi.ha.client.DiscoveryClientProvider$;
import org.apache.kyuubi.ha.client.DiscoveryPaths$;
import org.apache.kyuubi.ha.client.ServiceNodeInfo;
import org.yaml.snakeyaml.Yaml;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;

public final class CtlUtils$ {
    public static CtlUtils$ MODULE$;

    static {
        new CtlUtils$();
    }

    public String getZkServerNamespace(KyuubiConf conf, CliConfig cliConfig) {
        return DiscoveryPaths$.MODULE$.makePath(null, cliConfig.zkOpts().namespace(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
    }

    public Tuple2<String, Option<String>> getZkEngineNamespaceAndSubdomain(KyuubiConf conf, CliConfig cliConfig) {
        String engineType = (String)new Some((Object)cliConfig.engineOpts().engineType()).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)CtlUtils$.$anonfun$getZkEngineNamespaceAndSubdomain$1(x$1))).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)CtlUtils$.$anonfun$getZkEngineNamespaceAndSubdomain$2(x$2))).getOrElse((Function0 & Serializable & scala.Serializable)() -> (String)conf.get(KyuubiConf$.MODULE$.ENGINE_TYPE()));
        String engineShareLevel = (String)new Some((Object)cliConfig.engineOpts().engineShareLevel()).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)CtlUtils$.$anonfun$getZkEngineNamespaceAndSubdomain$4(x$3))).filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)CtlUtils$.$anonfun$getZkEngineNamespaceAndSubdomain$5(x$4))).getOrElse((Function0 & Serializable & scala.Serializable)() -> (String)conf.get(KyuubiConf$.MODULE$.ENGINE_SHARE_LEVEL()));
        Option engineSubdomain = Option$.MODULE$.apply((Object)cliConfig.engineOpts().engineSubdomain()).filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)CtlUtils$.$anonfun$getZkEngineNamespaceAndSubdomain$7(x$5))).orElse((Function0 & Serializable & scala.Serializable)() -> (Option)conf.get(KyuubiConf$.MODULE$.ENGINE_SHARE_LEVEL_SUBDOMAIN()));
        String rootPath = DiscoveryPaths$.MODULE$.makePath(new StringBuilder(3).append(cliConfig.zkOpts().namespace()).append("_").append(cliConfig.zkOpts().version()).append("_").append(engineShareLevel).append("_").append(engineType).toString(), cliConfig.engineOpts().user(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        return new Tuple2((Object)rootPath, (Object)engineSubdomain);
    }

    public Seq<ServiceNodeInfo> listZkServerNodes(KyuubiConf conf, CliConfig cliConfig, Option<Tuple2<String, Object>> hostPortOpt) {
        return (Seq)DiscoveryClientProvider$.MODULE$.withDiscoveryClient(conf, (Function1 & Serializable & scala.Serializable)discoveryClient -> {
            String znodeRoot = MODULE$.getZkServerNamespace(conf, cliConfig);
            return MODULE$.getServiceNodes((DiscoveryClient)discoveryClient, znodeRoot, hostPortOpt);
        });
    }

    public Seq<ServiceNodeInfo> listZkEngineNodes(KyuubiConf conf, CliConfig cliConfig, Option<Tuple2<String, Object>> hostPortOpt) {
        return (Seq)DiscoveryClientProvider$.MODULE$.withDiscoveryClient(conf, (Function1 & Serializable & scala.Serializable)discoveryClient -> {
            List list;
            Tuple2<String, Option<String>> tuple2 = MODULE$.getZkEngineNamespaceAndSubdomain(conf, cliConfig);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String znodeRoot = (String)tuple2._1();
            Option subdomainOpt = (Option)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)znodeRoot, (Object)subdomainOpt);
            String znodeRoot2 = (String)tuple22._1();
            Option subdomainOpt2 = (Option)tuple22._2();
            List candidates = discoveryClient.getChildren(znodeRoot2);
            Option option = subdomainOpt2;
            if (option instanceof Some) {
                Some some = (Some)option;
                String subdomain2 = (String)some.value();
                list = (List)candidates.filter((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)CtlUtils$.$anonfun$listZkEngineNodes$2(subdomain2, x$7)));
            } else if (None$.MODULE$.equals(option)) {
                list = candidates;
            } else {
                throw new MatchError((Object)option);
            }
            List matched = list;
            return (Seq)matched.flatMap((Function1 & Serializable & scala.Serializable)subdomain -> MODULE$.getServiceNodes((DiscoveryClient)discoveryClient, new StringBuilder(1).append(znodeRoot2).append("/").append((String)subdomain).toString(), hostPortOpt), List$.MODULE$.canBuildFrom());
        });
    }

    public Seq<ServiceNodeInfo> getServiceNodes(DiscoveryClient discoveryClient, String znodeRoot, Option<Tuple2<String, Object>> hostPortOpt) {
        Seq serviceNodes = discoveryClient.getServiceNodesInfo(znodeRoot, discoveryClient.getServiceNodesInfo$default$2(), discoveryClient.getServiceNodesInfo$default$3());
        return (Seq)hostPortOpt.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String host = (String)tuple2._1();
                int port = tuple2._2$mcI$sp();
                return (Seq)serviceNodes.filter((Function1 & Serializable & scala.Serializable)sn -> BoxesRunTime.boxToBoolean((boolean)CtlUtils$.$anonfun$getServiceNodes$2(host, port, sn)));
            }
            throw new MatchError((Object)tuple2);
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> serviceNodes);
    }

    public Map<String, Object> loadYamlAsMap(CliConfig cliConfig) {
        String filename = cliConfig.createOpts().filename();
        Map map = null;
        try (BufferedReader br = null;){
            try {
                Yaml yaml = new Yaml();
                FileInputStream input = new FileInputStream(new File(filename));
                br = new BufferedReader(new InputStreamReader((InputStream)input, StandardCharsets.UTF_8));
                map = (Map)yaml.load((Reader)br);
            }
            catch (Exception e) {
                throw new KyuubiException(new StringBuilder(28).append("Failed to read yaml file[").append(filename).append("]: ").append(e).toString(), KyuubiException$.MODULE$.$lessinit$greater$default$2());
            }
        }
        return map;
    }

    public static final /* synthetic */ boolean $anonfun$getZkEngineNamespaceAndSubdomain$1(String x$1) {
        return x$1 != null;
    }

    public static final /* synthetic */ boolean $anonfun$getZkEngineNamespaceAndSubdomain$2(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$getZkEngineNamespaceAndSubdomain$4(String x$3) {
        return x$3 != null;
    }

    public static final /* synthetic */ boolean $anonfun$getZkEngineNamespaceAndSubdomain$5(String x$4) {
        return new StringOps(Predef$.MODULE$.augmentString(x$4)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$getZkEngineNamespaceAndSubdomain$7(String x$5) {
        return new StringOps(Predef$.MODULE$.augmentString(x$5)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$listZkEngineNodes$2(String subdomain$1, String x$7) {
        String string = x$7;
        String string2 = subdomain$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getServiceNodes$2(String host$1, int port$1, ServiceNodeInfo sn) {
        String string = sn.host();
        String string2 = host$1;
        return !(string != null ? !string.equals(string2) : string2 != null) && sn.port() == port$1;
    }

    private CtlUtils$() {
        MODULE$ = this;
    }
}

