/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.deployment.application.executors;

import java.time.Duration;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.client.cli.ClientOptions;
import org.apache.flink.client.deployment.application.EmbeddedJobClient;
import org.apache.flink.client.deployment.application.executors.EmbeddedExecutor;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.DeploymentOptions;
import org.apache.flink.core.execution.PipelineExecutor;
import org.apache.flink.core.execution.PipelineExecutorFactory;
import org.apache.flink.runtime.dispatcher.DispatcherGateway;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.concurrent.ScheduledExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class EmbeddedExecutorFactory
implements PipelineExecutorFactory {
    private static Collection<JobID> bootstrapJobIds;
    private static Collection<JobID> submittedJobIds;
    private static DispatcherGateway dispatcherGateway;
    private static ScheduledExecutor retryExecutor;
    private static final Object bootstrapLock;
    private static final long BOOTSTRAP_WAIT_INTERVAL = 10000L;
    private static final int BOOTSTRAP_WAIT_RETRIES = 3;
    private static final Logger LOGGER;

    public EmbeddedExecutorFactory() {
        LOGGER.debug("{} loaded in thread {} with classloader {}.", new Object[]{this.getClass().getCanonicalName(), Thread.currentThread().getName(), this.getClass().getClassLoader().toString()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EmbeddedExecutorFactory(Collection<JobID> submittedJobIds, DispatcherGateway dispatcherGateway, ScheduledExecutor retryExecutor) {
        LOGGER.debug("{} initiated in thread {} with classloader {}.", new Object[]{this.getClass().getCanonicalName(), Thread.currentThread().getName(), this.getClass().getClassLoader().toString()});
        Preconditions.checkState((EmbeddedExecutorFactory.submittedJobIds == null ? 1 : 0) != 0);
        Preconditions.checkState((EmbeddedExecutorFactory.dispatcherGateway == null ? 1 : 0) != 0);
        Preconditions.checkState((EmbeddedExecutorFactory.retryExecutor == null ? 1 : 0) != 0);
        Object object = bootstrapLock;
        synchronized (object) {
            LOGGER.debug("Bootstrapping EmbeddedExecutorFactory.");
            EmbeddedExecutorFactory.submittedJobIds = new ConcurrentLinkedQueue<JobID>((Collection)Preconditions.checkNotNull(submittedJobIds));
            bootstrapJobIds = submittedJobIds;
            EmbeddedExecutorFactory.dispatcherGateway = (DispatcherGateway)Preconditions.checkNotNull((Object)dispatcherGateway);
            EmbeddedExecutorFactory.retryExecutor = (ScheduledExecutor)Preconditions.checkNotNull((Object)retryExecutor);
            bootstrapLock.notifyAll();
        }
    }

    public String getName() {
        return "embedded";
    }

    public boolean isCompatibleWith(Configuration configuration) {
        LOGGER.debug("Matching execution target: {}", configuration.get(DeploymentOptions.TARGET));
        return ((String)configuration.get(DeploymentOptions.TARGET)).equalsIgnoreCase("yarn-application") && configuration.toMap().getOrDefault("yarn.tags", "").toLowerCase().contains("kyuubi");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PipelineExecutor getExecutor(Configuration configuration) {
        Collection<JobID> executorJobIDs;
        Preconditions.checkNotNull((Object)configuration);
        Object object = bootstrapLock;
        synchronized (object) {
            for (int retry = 0; bootstrapJobIds == null && retry < 3; ++retry) {
                try {
                    LOGGER.debug("Waiting for bootstrap to complete. Wait retries: {}.", (Object)retry);
                    bootstrapLock.wait(10000L);
                    continue;
                }
                catch (InterruptedException e) {
                    throw new RuntimeException("Interrupted while waiting for bootstrap.", e);
                }
            }
            if (bootstrapJobIds == null) {
                throw new RuntimeException("Bootstrap of Flink SQL engine timed out after 30000 ms. Please check the engine log for more details.");
            }
        }
        if (bootstrapJobIds.size() > 0) {
            LOGGER.info("Submitting new Kyuubi job. Job submitted: {}.", (Object)submittedJobIds.size());
            executorJobIDs = submittedJobIds;
        } else {
            LOGGER.info("Bootstrapping Flink SQL engine with the initial SQL.");
            executorJobIDs = bootstrapJobIds;
        }
        return new EmbeddedExecutor(executorJobIDs, dispatcherGateway, (jobId, userCodeClassloader) -> {
            Time timeout = Time.milliseconds((long)((Duration)configuration.get(ClientOptions.CLIENT_TIMEOUT)).toMillis());
            return new EmbeddedJobClient(jobId, dispatcherGateway, retryExecutor, timeout, userCodeClassloader);
        });
    }

    static {
        bootstrapLock = new Object();
        LOGGER = LoggerFactory.getLogger(EmbeddedExecutorFactory.class);
    }
}

