/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.test.junit;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import org.apache.logging.log4j.test.TestProperties;
import org.apache.logging.log4j.test.junit.SetTestProperty;
import org.apache.logging.log4j.test.junit.TestPropertySource;
import org.apache.logging.log4j.test.junit.TypeBasedParameterResolver;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junit.platform.commons.support.HierarchyTraversalMode;
import org.junit.platform.commons.support.ModifierSupport;
import org.junit.platform.commons.support.ReflectionSupport;

public class TestPropertyResolver
extends TypeBasedParameterResolver<TestProperties>
implements BeforeAllCallback,
BeforeEachCallback {
    public TestPropertyResolver() {
        super((Type)((Object)TestProperties.class));
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        TestProperties props = TestPropertySource.createProperties(context);
        AnnotationSupport.findRepeatableAnnotations((AnnotatedElement)context.getRequiredTestMethod(), SetTestProperty.class).forEach(setProperty -> props.setProperty(setProperty.key(), setProperty.value()));
        Class testClass = context.getRequiredTestClass();
        Object testInstance = context.getRequiredTestInstance();
        ReflectionSupport.findFields((Class)testClass, field -> ModifierSupport.isNotStatic((Member)field) && field.getType().equals(TestProperties.class), (HierarchyTraversalMode)HierarchyTraversalMode.BOTTOM_UP).forEach(field -> {
            try {
                field.setAccessible(true);
                field.set(testInstance, props);
            }
            catch (IllegalAccessException e) {
                throw new UnsupportedOperationException(e);
            }
        });
    }

    public void beforeAll(ExtensionContext context) throws Exception {
        TestProperties props = TestPropertySource.createProperties(context);
        AnnotationSupport.findRepeatableAnnotations((AnnotatedElement)context.getRequiredTestClass(), SetTestProperty.class).forEach(setProperty -> props.setProperty(setProperty.key(), setProperty.value()));
        Class testClass = context.getRequiredTestClass();
        ReflectionSupport.findFields((Class)testClass, field -> ModifierSupport.isStatic((Member)field) && field.getType().equals(TestProperties.class), (HierarchyTraversalMode)HierarchyTraversalMode.BOTTOM_UP).forEach(field -> {
            try {
                field.setAccessible(true);
                field.set(null, props);
            }
            catch (IllegalAccessException e) {
                throw new UnsupportedOperationException(e);
            }
        });
    }

    @Override
    public TestProperties resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return TestPropertySource.createProperties(extensionContext);
    }
}

