/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class MultilineMessageHelper {
    private static final int DEFAULT_MAX_SIZE = 65;
    private static final char BOX_CHAR = '*';
    private static final Pattern S_FILTER = Pattern.compile("\\s+");

    public static String separatorLine() {
        StringBuilder sb = new StringBuilder(65);
        MultilineMessageHelper.repeat(sb, '*', 65);
        return sb.toString();
    }

    public static List<String> format(String ... lines) {
        int size = 65;
        int remainder = size - 4;
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder sb = new StringBuilder(size);
        sb.setLength(0);
        MultilineMessageHelper.repeat(sb, '*', size);
        result.add(sb.toString());
        for (String line : lines) {
            String[] words;
            sb.setLength(0);
            for (String word : words = S_FILTER.split(line)) {
                if (sb.length() >= remainder - word.length() - (sb.length() > 0 ? 1 : 0)) {
                    MultilineMessageHelper.repeat(sb, ' ', remainder - sb.length());
                    result.add("* " + sb + " " + '*');
                    sb.setLength(0);
                }
                if (sb.length() > 0) {
                    sb.append(' ');
                }
                sb.append(word);
            }
            while (sb.length() < remainder) {
                sb.append(' ');
            }
            result.add("* " + sb + " " + '*');
        }
        sb.setLength(0);
        MultilineMessageHelper.repeat(sb, '*', size);
        result.add(sb.toString());
        return result;
    }

    private static void repeat(StringBuilder sb, char c, int nb) {
        for (int i = 0; i < nb; ++i) {
            sb.append(c);
        }
    }
}

