/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.encryption;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import org.apache.qpid.server.security.encryption.ConfigurationSecretEncrypter;
import org.apache.qpid.server.security.encryption.EncryptionHelper;
import org.apache.qpid.server.util.Strings;

class AESGCMKeyFileEncrypter
implements ConfigurationSecretEncrypter {
    private static final String CIPHER_NAME = "AES/GCM/NoPadding";
    private static final int GCM_INITIALIZATION_VECTOR_LENGTH = 12;
    private static final int GCM_TAG_LENGTH = 128;
    private static final String AES_ALGORITHM = "AES";
    private final SecureRandom _random = new SecureRandom();
    private final SecretKey _secretKey;

    AESGCMKeyFileEncrypter(SecretKey secretKey) {
        if (secretKey == null) {
            throw new IllegalArgumentException("A non null secret key must be supplied");
        }
        if (!AES_ALGORITHM.equals(secretKey.getAlgorithm())) {
            throw new IllegalArgumentException(String.format("Provided secret key was for the algorithm: %s when %s was needed.", secretKey.getAlgorithm(), AES_ALGORITHM));
        }
        this._secretKey = secretKey;
    }

    @Override
    public String encrypt(String unencrypted) {
        byte[] unencryptedBytes = unencrypted.getBytes(StandardCharsets.UTF_8);
        try {
            byte[] initializationVectorBytes = new byte[12];
            this._random.nextBytes(initializationVectorBytes);
            Cipher cipher = Cipher.getInstance(CIPHER_NAME);
            GCMParameterSpec gcmParameterSpec = new GCMParameterSpec(128, initializationVectorBytes);
            cipher.init(1, (Key)this._secretKey, gcmParameterSpec);
            byte[] encryptedBytes = EncryptionHelper.readFromCipherStream(unencryptedBytes, cipher);
            byte[] output = new byte[12 + encryptedBytes.length];
            System.arraycopy(initializationVectorBytes, 0, output, 0, 12);
            System.arraycopy(encryptedBytes, 0, output, 12, encryptedBytes.length);
            return Base64.getEncoder().encodeToString(output);
        }
        catch (IOException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new IllegalArgumentException("Unable to encrypt secret", e);
        }
    }

    @Override
    public String decrypt(String encrypted) {
        if (!EncryptionHelper.isValidBase64(encrypted)) {
            throw new IllegalArgumentException(String.format("Encrypted value is not valid Base 64 data: '%s'", encrypted));
        }
        byte[] encryptedBytes = Strings.decodeBase64(encrypted);
        if (encryptedBytes.length < 12) {
            throw new IllegalArgumentException(String.format("Encrypted value length is less than expected : '%s'", encrypted));
        }
        try {
            Cipher cipher = Cipher.getInstance(CIPHER_NAME);
            byte[] initializationVectorBytes = new byte[12];
            System.arraycopy(encryptedBytes, 0, initializationVectorBytes, 0, 12);
            GCMParameterSpec gcmParameterSpec = new GCMParameterSpec(128, initializationVectorBytes);
            cipher.init(2, (Key)this._secretKey, gcmParameterSpec);
            return new String(EncryptionHelper.readFromCipherStream(encryptedBytes, 12, encryptedBytes.length - 12, cipher), StandardCharsets.UTF_8);
        }
        catch (IOException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new IllegalArgumentException("Unable to decrypt secret", e);
        }
    }
}

