/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store.derby;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.store.FileBasedSettings;
import org.apache.qpid.server.store.StoreException;
import org.apache.qpid.server.store.derby.AbstractDerbyMessageStore;
import org.apache.qpid.server.store.derby.DerbyUtils;
import org.apache.qpid.server.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DerbyMessageStore
extends AbstractDerbyMessageStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(DerbyMessageStore.class);
    private String _connectionURL;
    private ConfiguredObject<?> _parent;

    @Override
    protected void doOpen(ConfiguredObject<?> parent) {
        this._parent = parent;
        this._connectionURL = DerbyUtils.createConnectionUrl(parent.getName(), ((FileBasedSettings)this._parent).getStorePath());
    }

    public Connection getConnection() throws SQLException {
        this.checkMessageStoreOpen();
        return DriverManager.getConnection(this._connectionURL);
    }

    @Override
    protected void doClose() {
        try {
            DerbyUtils.shutdownDatabase(this._connectionURL);
        }
        catch (SQLException e) {
            throw new StoreException("Error closing configuration store", (Throwable)e);
        }
    }

    public void onDelete(ConfiguredObject parent) {
        if (this.isMessageStoreOpen()) {
            throw new IllegalStateException("Cannot delete the store as store is still open");
        }
        FileBasedSettings fileBasedSettings = (FileBasedSettings)parent;
        String storePath = fileBasedSettings.getStorePath();
        if (storePath != null) {
            LOGGER.debug("Deleting store : {}", (Object)storePath);
            File configFile = new File(storePath);
            if (!FileUtils.delete((File)configFile, (boolean)true)) {
                LOGGER.info("Failed to delete the store at location : {}", (Object)storePath);
            }
        }
    }

    protected Logger getLogger() {
        return LOGGER;
    }

    public String getStoreLocation() {
        return ((FileBasedSettings)this._parent).getStorePath();
    }

    public File getStoreLocationAsFile() {
        return DerbyUtils.isInMemoryDatabase(this.getStoreLocation()) ? null : new File(this.getStoreLocation());
    }
}

