/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.failover;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.broker.transaction.queue.TransactionalMessageUtil;
import org.apache.rocketmq.client.consumer.PullResult;
import org.apache.rocketmq.client.consumer.PullStatus;
import org.apache.rocketmq.client.exception.MQBrokerException;
import org.apache.rocketmq.client.impl.producer.TopicPublishInfo;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.client.producer.SendStatus;
import org.apache.rocketmq.common.ThreadFactoryImpl;
import org.apache.rocketmq.common.message.MessageDecoder;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.common.message.MessageExtBrokerInner;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.common.utils.ThreadUtils;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.exception.RemotingException;
import org.apache.rocketmq.store.GetMessageResult;
import org.apache.rocketmq.store.GetMessageStatus;
import org.apache.rocketmq.store.MessageStore;
import org.apache.rocketmq.store.PutMessageResult;
import org.apache.rocketmq.store.PutMessageStatus;
import org.apache.rocketmq.tieredstore.TieredMessageStore;

public class EscapeBridge {
    protected static final Logger LOG = LoggerFactory.getLogger((String)"RocketmqBroker");
    private static final long SEND_TIMEOUT = 3000L;
    private static final long DEFAULT_PULL_TIMEOUT_MILLIS = 10000L;
    private final String innerProducerGroupName;
    private final String innerConsumerGroupName;
    private final BrokerController brokerController;
    private ExecutorService defaultAsyncSenderExecutor;

    public EscapeBridge(BrokerController brokerController) {
        this.brokerController = brokerController;
        this.innerProducerGroupName = "InnerProducerGroup_" + brokerController.getBrokerConfig().getBrokerName() + "_" + brokerController.getBrokerConfig().getBrokerId();
        this.innerConsumerGroupName = "InnerConsumerGroup_" + brokerController.getBrokerConfig().getBrokerName() + "_" + brokerController.getBrokerConfig().getBrokerId();
    }

    public void start() throws Exception {
        if (this.brokerController.getBrokerConfig().isEnableSlaveActingMaster() && this.brokerController.getBrokerConfig().isEnableRemoteEscape()) {
            LinkedBlockingQueue asyncSenderThreadPoolQueue = new LinkedBlockingQueue(50000);
            this.defaultAsyncSenderExecutor = ThreadUtils.newThreadPoolExecutor((int)Runtime.getRuntime().availableProcessors(), (int)Runtime.getRuntime().availableProcessors(), (long)60000L, (TimeUnit)TimeUnit.MILLISECONDS, asyncSenderThreadPoolQueue, (ThreadFactory)new ThreadFactoryImpl("AsyncEscapeBridgeExecutor_", this.brokerController.getBrokerIdentity()));
            LOG.info("init executor for escaping messages asynchronously success.");
        }
    }

    public void shutdown() {
        if (null != this.defaultAsyncSenderExecutor) {
            this.defaultAsyncSenderExecutor.shutdown();
        }
    }

    public PutMessageResult putMessage(MessageExtBrokerInner messageExt) {
        BrokerController masterBroker = this.brokerController.peekMasterBroker();
        if (masterBroker != null) {
            return masterBroker.getMessageStore().putMessage(messageExt);
        }
        if (this.brokerController.getBrokerConfig().isEnableSlaveActingMaster() && this.brokerController.getBrokerConfig().isEnableRemoteEscape()) {
            try {
                messageExt.setWaitStoreMsgOK(false);
                SendResult sendResult = this.putMessageToRemoteBroker(messageExt, null);
                return this.transformSendResult2PutResult(sendResult);
            }
            catch (Exception e) {
                LOG.error("sendMessageInFailover to remote failed", (Throwable)e);
                return new PutMessageResult(PutMessageStatus.PUT_TO_REMOTE_BROKER_FAIL, null, true);
            }
        }
        LOG.warn("Put message failed, enableSlaveActingMaster={}, enableRemoteEscape={}.", (Object)this.brokerController.getBrokerConfig().isEnableSlaveActingMaster(), (Object)this.brokerController.getBrokerConfig().isEnableRemoteEscape());
        return new PutMessageResult(PutMessageStatus.SERVICE_NOT_AVAILABLE, null);
    }

    public SendResult putMessageToRemoteBroker(MessageExtBrokerInner messageExt, String brokerNameToSend) {
        String brokerAddrToSend;
        MessageQueue mqSelected;
        TopicPublishInfo topicPublishInfo;
        if (this.brokerController.getBrokerConfig().getBrokerName().equals(brokerNameToSend)) {
            return null;
        }
        boolean isTransHalfMessage = TransactionalMessageUtil.buildHalfTopic().equals(messageExt.getTopic());
        MessageExtBrokerInner messageToPut = messageExt;
        if (isTransHalfMessage) {
            messageToPut = TransactionalMessageUtil.buildTransactionalMessageFromHalfMessage((MessageExt)messageExt);
        }
        if (null == (topicPublishInfo = this.brokerController.getTopicRouteInfoManager().tryToFindTopicPublishInfo(messageToPut.getTopic())) || !topicPublishInfo.ok()) {
            LOG.warn("putMessageToRemoteBroker: no route info of topic {} when escaping message, msgId={}", (Object)messageToPut.getTopic(), (Object)messageToPut.getMsgId());
            return null;
        }
        if (StringUtils.isEmpty((CharSequence)brokerNameToSend)) {
            mqSelected = topicPublishInfo.selectOneMessageQueue(this.brokerController.getBrokerConfig().getBrokerName());
            messageToPut.setQueueId(mqSelected.getQueueId());
            brokerNameToSend = mqSelected.getBrokerName();
            if (this.brokerController.getBrokerConfig().getBrokerName().equals(brokerNameToSend)) {
                LOG.warn("putMessageToRemoteBroker failed, remote broker not found. Topic: {}, MsgId: {}, Broker: {}", new Object[]{messageExt.getTopic(), messageExt.getMsgId(), brokerNameToSend});
                return null;
            }
        } else {
            mqSelected = new MessageQueue(messageExt.getTopic(), brokerNameToSend, messageExt.getQueueId());
        }
        if (null == (brokerAddrToSend = this.brokerController.getTopicRouteInfoManager().findBrokerAddressInPublish(brokerNameToSend))) {
            LOG.warn("putMessageToRemoteBroker failed, remote broker address not found. Topic: {}, MsgId: {}, Broker: {}", new Object[]{messageExt.getTopic(), messageExt.getMsgId(), brokerNameToSend});
            return null;
        }
        long beginTimestamp = System.currentTimeMillis();
        try {
            SendResult sendResult = this.brokerController.getBrokerOuterAPI().sendMessageToSpecificBroker(brokerAddrToSend, brokerNameToSend, (MessageExt)messageToPut, this.getProducerGroup(messageToPut), 3000L);
            if (null != sendResult && SendStatus.SEND_OK.equals((Object)sendResult.getSendStatus())) {
                return sendResult;
            }
            LOG.error("Escaping failed! cost {}ms, Topic: {}, MsgId: {}, Broker: {}", new Object[]{System.currentTimeMillis() - beginTimestamp, messageExt.getTopic(), messageExt.getMsgId(), brokerNameToSend});
        }
        catch (MQBrokerException | RemotingException e) {
            LOG.error(String.format("putMessageToRemoteBroker exception, MsgId: %s, RT: %sms, Broker: %s", messageToPut.getMsgId(), System.currentTimeMillis() - beginTimestamp, mqSelected), e);
        }
        catch (InterruptedException e) {
            LOG.error(String.format("putMessageToRemoteBroker interrupted, MsgId: %s, RT: %sms, Broker: %s", messageToPut.getMsgId(), System.currentTimeMillis() - beginTimestamp, mqSelected), (Throwable)e);
            Thread.currentThread().interrupt();
        }
        return null;
    }

    public CompletableFuture<PutMessageResult> asyncPutMessage(MessageExtBrokerInner messageExt) {
        BrokerController masterBroker = this.brokerController.peekMasterBroker();
        if (masterBroker != null) {
            return masterBroker.getMessageStore().asyncPutMessage(messageExt);
        }
        if (this.brokerController.getBrokerConfig().isEnableSlaveActingMaster() && this.brokerController.getBrokerConfig().isEnableRemoteEscape()) {
            try {
                messageExt.setWaitStoreMsgOK(false);
                TopicPublishInfo topicPublishInfo = this.brokerController.getTopicRouteInfoManager().tryToFindTopicPublishInfo(messageExt.getTopic());
                String producerGroup = this.getProducerGroup(messageExt);
                MessageQueue mqSelected = topicPublishInfo.selectOneMessageQueue();
                messageExt.setQueueId(mqSelected.getQueueId());
                String brokerNameToSend = mqSelected.getBrokerName();
                String brokerAddrToSend = this.brokerController.getTopicRouteInfoManager().findBrokerAddressInPublish(brokerNameToSend);
                CompletableFuture<SendResult> future = this.brokerController.getBrokerOuterAPI().sendMessageToSpecificBrokerAsync(brokerAddrToSend, brokerNameToSend, (MessageExt)messageExt, producerGroup, 3000L);
                return ((CompletableFuture)((CompletableFuture)future.exceptionally(throwable -> null)).thenApplyAsync(this::transformSendResult2PutResult, (Executor)this.defaultAsyncSenderExecutor)).exceptionally(throwable -> this.transformSendResult2PutResult(null));
            }
            catch (Exception e) {
                LOG.error("sendMessageInFailover to remote failed", (Throwable)e);
                return CompletableFuture.completedFuture(new PutMessageResult(PutMessageStatus.PUT_TO_REMOTE_BROKER_FAIL, null, true));
            }
        }
        LOG.warn("Put message failed, enableSlaveActingMaster={}, enableRemoteEscape={}.", (Object)this.brokerController.getBrokerConfig().isEnableSlaveActingMaster(), (Object)this.brokerController.getBrokerConfig().isEnableRemoteEscape());
        return CompletableFuture.completedFuture(new PutMessageResult(PutMessageStatus.SERVICE_NOT_AVAILABLE, null));
    }

    private String getProducerGroup(MessageExtBrokerInner messageExt) {
        if (null == messageExt) {
            return this.innerProducerGroupName;
        }
        String producerGroup = messageExt.getProperty("PGROUP");
        if (StringUtils.isEmpty((CharSequence)producerGroup)) {
            producerGroup = this.innerProducerGroupName;
        }
        return producerGroup;
    }

    public PutMessageResult putMessageToSpecificQueue(MessageExtBrokerInner messageExt) {
        BrokerController masterBroker = this.brokerController.peekMasterBroker();
        if (masterBroker != null) {
            return masterBroker.getMessageStore().putMessage(messageExt);
        }
        try {
            return this.asyncRemotePutMessageToSpecificQueue(messageExt).get(3000L, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            LOG.error("Put message to specific queue error", (Throwable)e);
            return new PutMessageResult(PutMessageStatus.UNKNOWN_ERROR, null, true);
        }
    }

    public CompletableFuture<PutMessageResult> asyncPutMessageToSpecificQueue(MessageExtBrokerInner messageExt) {
        BrokerController masterBroker = this.brokerController.peekMasterBroker();
        if (masterBroker != null) {
            return masterBroker.getMessageStore().asyncPutMessage(messageExt);
        }
        return this.asyncRemotePutMessageToSpecificQueue(messageExt);
    }

    public CompletableFuture<PutMessageResult> asyncRemotePutMessageToSpecificQueue(MessageExtBrokerInner messageExt) {
        if (this.brokerController.getBrokerConfig().isEnableSlaveActingMaster() && this.brokerController.getBrokerConfig().isEnableRemoteEscape()) {
            try {
                messageExt.setWaitStoreMsgOK(false);
                TopicPublishInfo topicPublishInfo = this.brokerController.getTopicRouteInfoManager().tryToFindTopicPublishInfo(messageExt.getTopic());
                List mqs = topicPublishInfo.getMessageQueueList();
                if (null == mqs || mqs.isEmpty()) {
                    return CompletableFuture.completedFuture(new PutMessageResult(PutMessageStatus.PUT_TO_REMOTE_BROKER_FAIL, null, true));
                }
                String id = messageExt.getTopic() + messageExt.getStoreHost();
                int index = Math.floorMod(id.hashCode(), mqs.size());
                MessageQueue mq = (MessageQueue)mqs.get(index);
                messageExt.setQueueId(mq.getQueueId());
                String brokerNameToSend = mq.getBrokerName();
                String brokerAddrToSend = this.brokerController.getTopicRouteInfoManager().findBrokerAddressInPublish(brokerNameToSend);
                return this.brokerController.getBrokerOuterAPI().sendMessageToSpecificBrokerAsync(brokerAddrToSend, brokerNameToSend, (MessageExt)messageExt, this.getProducerGroup(messageExt), 3000L).thenCompose(sendResult -> CompletableFuture.completedFuture(this.transformSendResult2PutResult((SendResult)sendResult)));
            }
            catch (Exception e) {
                LOG.error("sendMessageInFailover to remote failed", (Throwable)e);
                return CompletableFuture.completedFuture(new PutMessageResult(PutMessageStatus.PUT_TO_REMOTE_BROKER_FAIL, null, true));
            }
        }
        LOG.warn("Put message to specific queue failed, enableSlaveActingMaster={}, enableRemoteEscape={}.", (Object)this.brokerController.getBrokerConfig().isEnableSlaveActingMaster(), (Object)this.brokerController.getBrokerConfig().isEnableRemoteEscape());
        return CompletableFuture.completedFuture(new PutMessageResult(PutMessageStatus.SERVICE_NOT_AVAILABLE, null));
    }

    private PutMessageResult transformSendResult2PutResult(SendResult sendResult) {
        if (sendResult == null) {
            return new PutMessageResult(PutMessageStatus.PUT_TO_REMOTE_BROKER_FAIL, null, true);
        }
        switch (sendResult.getSendStatus()) {
            case SEND_OK: {
                return new PutMessageResult(PutMessageStatus.PUT_OK, null, true);
            }
            case SLAVE_NOT_AVAILABLE: {
                return new PutMessageResult(PutMessageStatus.SLAVE_NOT_AVAILABLE, null, true);
            }
            case FLUSH_DISK_TIMEOUT: {
                return new PutMessageResult(PutMessageStatus.FLUSH_DISK_TIMEOUT, null, true);
            }
            case FLUSH_SLAVE_TIMEOUT: {
                return new PutMessageResult(PutMessageStatus.FLUSH_SLAVE_TIMEOUT, null, true);
            }
        }
        return new PutMessageResult(PutMessageStatus.PUT_TO_REMOTE_BROKER_FAIL, null, true);
    }

    public Triple<MessageExt, String, Boolean> getMessage(String topic, long offset, int queueId, String brokerName, boolean deCompressBody) {
        return this.getMessageAsync(topic, offset, queueId, brokerName, deCompressBody).join();
    }

    public CompletableFuture<Triple<MessageExt, String, Boolean>> getMessageAsync(String topic, long offset, int queueId, String brokerName, boolean deCompressBody) {
        MessageStore messageStore = this.brokerController.getMessageStoreByBrokerName(brokerName);
        if (messageStore != null) {
            return messageStore.getMessageAsync(this.innerConsumerGroupName, topic, queueId, offset, 1, null).thenApply(result -> {
                if (result == null) {
                    LOG.warn("getMessageResult is null , innerConsumerGroupName {}, topic {}, offset {}, queueId {}", new Object[]{this.innerConsumerGroupName, topic, offset, queueId});
                    return Triple.of(null, (Object)"getMessageResult is null", (Object)false);
                }
                List<MessageExt> list = this.decodeMsgList((GetMessageResult)result, deCompressBody);
                if (list == null || list.isEmpty()) {
                    boolean needRetry = GetMessageStatus.OFFSET_FOUND_NULL.equals((Object)result.getStatus()) && messageStore instanceof TieredMessageStore;
                    LOG.warn("Can not get msg , topic {}, offset {}, queueId {}, needRetry {}, result is {}", new Object[]{topic, offset, queueId, needRetry, result});
                    return Triple.of(null, (Object)"Can not get msg", (Object)needRetry);
                }
                return Triple.of((Object)list.get(0), (Object)"", (Object)false);
            });
        }
        return this.getMessageFromRemoteAsync(topic, offset, queueId, brokerName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<MessageExt> decodeMsgList(GetMessageResult getMessageResult, boolean deCompressBody) {
        ArrayList<MessageExt> foundList = new ArrayList<MessageExt>();
        try {
            List messageBufferList = getMessageResult.getMessageBufferList();
            if (messageBufferList != null) {
                for (int i = 0; i < messageBufferList.size(); ++i) {
                    ByteBuffer bb = (ByteBuffer)messageBufferList.get(i);
                    if (bb == null) {
                        LOG.error("bb is null {}", (Object)getMessageResult);
                        continue;
                    }
                    MessageExt msgExt = MessageDecoder.decode((ByteBuffer)bb, (boolean)true, (boolean)deCompressBody);
                    if (msgExt == null) {
                        LOG.error("decode msgExt is null {}", (Object)getMessageResult);
                        continue;
                    }
                    msgExt.setQueueOffset(((Long)getMessageResult.getMessageQueueOffset().get(i)).longValue());
                    foundList.add(msgExt);
                }
            }
        }
        finally {
            getMessageResult.release();
        }
        return foundList;
    }

    protected Triple<MessageExt, String, Boolean> getMessageFromRemote(String topic, long offset, int queueId, String brokerName) {
        return this.getMessageFromRemoteAsync(topic, offset, queueId, brokerName).join();
    }

    protected CompletableFuture<Triple<MessageExt, String, Boolean>> getMessageFromRemoteAsync(String topic, long offset, int queueId, String brokerName) {
        try {
            String brokerAddr = this.brokerController.getTopicRouteInfoManager().findBrokerAddressInSubscribe(brokerName, 0L, false);
            if (null == brokerAddr) {
                this.brokerController.getTopicRouteInfoManager().updateTopicRouteInfoFromNameServer(topic, true, false);
                brokerAddr = this.brokerController.getTopicRouteInfoManager().findBrokerAddressInSubscribe(brokerName, 0L, false);
                if (null == brokerAddr) {
                    LOG.warn("can't find broker address for topic {}, {}", (Object)topic, (Object)brokerName);
                    return CompletableFuture.completedFuture(Triple.of(null, (Object)"brokerAddress not found", (Object)true));
                }
            }
            return this.brokerController.getBrokerOuterAPI().pullMessageFromSpecificBrokerAsync(brokerName, brokerAddr, this.innerConsumerGroupName, topic, queueId, offset, 1, 10000L).thenApply(pullResult -> {
                if (pullResult.getLeft() != null && PullStatus.FOUND.equals((Object)((PullResult)pullResult.getLeft()).getPullStatus()) && CollectionUtils.isNotEmpty((Collection)((PullResult)pullResult.getLeft()).getMsgFoundList())) {
                    return Triple.of(((PullResult)pullResult.getLeft()).getMsgFoundList().get(0), (Object)"", (Object)false);
                }
                return Triple.of(null, (Object)pullResult.getMiddle(), (Object)pullResult.getRight());
            });
        }
        catch (Exception e) {
            LOG.error("Get message from remote failed. {}, {}, {}, {}", new Object[]{topic, offset, queueId, brokerName, e});
            return CompletableFuture.completedFuture(Triple.of(null, (Object)"Get message from remote failed", (Object)true));
        }
    }
}

