/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.common.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.rocketmq.common.utils.Shutdown;

public class AsyncShutdownHelper {
    private final AtomicBoolean shutdown;
    private final List<Shutdown> targetList = new ArrayList<Shutdown>();
    private CountDownLatch countDownLatch;

    public AsyncShutdownHelper() {
        this.shutdown = new AtomicBoolean(false);
    }

    public void addTarget(Shutdown target) {
        if (this.shutdown.get()) {
            return;
        }
        this.targetList.add(target);
    }

    public AsyncShutdownHelper shutdown() {
        if (this.shutdown.get()) {
            return this;
        }
        if (this.targetList.isEmpty()) {
            return this;
        }
        this.countDownLatch = new CountDownLatch(this.targetList.size());
        for (Shutdown target : this.targetList) {
            Runnable runnable = () -> {
                try {
                    target.shutdown();
                }
                catch (Exception exception) {
                }
                finally {
                    this.countDownLatch.countDown();
                }
            };
            new Thread(runnable).start();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean await(long time, TimeUnit unit) throws InterruptedException {
        if (this.shutdown.get()) {
            return false;
        }
        try {
            boolean bl = this.countDownLatch.await(time, unit);
            return bl;
        }
        finally {
            this.shutdown.compareAndSet(false, true);
        }
    }
}

