/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery.util;

import com.netflix.servo.DefaultMonitorRegistry;
import com.netflix.servo.monitor.LongGauge;
import com.netflix.servo.monitor.Monitor;
import com.netflix.servo.monitor.MonitorConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThresholdLevelsMetric {
    public static final ThresholdLevelsMetric NO_OP_METRIC = new NoOpThresholdLevelMetric();
    private static final Logger logger = LoggerFactory.getLogger(ThresholdLevelsMetric.class);
    private final long[] levels;
    private final LongGauge[] gauges;

    public ThresholdLevelsMetric(Object owner, String prefix, long[] levels) {
        this.levels = levels;
        this.gauges = new LongGauge[levels.length];
        for (int i = 0; i < levels.length; ++i) {
            String name = prefix + String.format("%05d", levels[i]);
            MonitorConfig config = new MonitorConfig.Builder(name).withTag("class", owner.getClass().getName()).build();
            this.gauges[i] = new LongGauge(config);
            try {
                DefaultMonitorRegistry.getInstance().register((Monitor)this.gauges[i]);
                continue;
            }
            catch (Throwable e) {
                logger.warn("Cannot register metric {}", (Object)name, (Object)e);
            }
        }
    }

    public void update(long delayMs) {
        int i;
        long matchedIdx;
        long delaySec = delayMs / 1000L;
        if (this.levels[0] > delaySec) {
            matchedIdx = -1L;
        } else {
            matchedIdx = this.levels.length - 1;
            for (i = 0; i < this.levels.length - 1; ++i) {
                if (this.levels[i] > delaySec || delaySec >= this.levels[i + 1]) continue;
                matchedIdx = i;
                break;
            }
        }
        for (i = 0; i < this.levels.length; ++i) {
            if ((long)i == matchedIdx) {
                this.gauges[i].set(Long.valueOf(1L));
                continue;
            }
            this.gauges[i].set(Long.valueOf(0L));
        }
    }

    public void shutdown() {
        for (LongGauge gauge : this.gauges) {
            try {
                DefaultMonitorRegistry.getInstance().unregister((Monitor)gauge);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static class NoOpThresholdLevelMetric
    extends ThresholdLevelsMetric {
        public NoOpThresholdLevelMetric() {
            super(null, null, new long[0]);
        }

        @Override
        public void update(long delayMs) {
        }

        @Override
        public void shutdown() {
        }
    }
}

