/*
 * Decompiled with CFR 0.152.
 */
package reactor.test.util;

import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import reactor.core.Exceptions;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

public class RaceTestUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> boolean race(T initial, Function<? super T, ? extends T> race, Predicate<? super T> stopRace, BiPredicate<? super T, ? super T> terminate) {
        Scheduler w1 = Schedulers.newSingle((String)"w1");
        Scheduler w2 = Schedulers.newSingle((String)"w2");
        try {
            AtomicReference ref1 = new AtomicReference();
            CountDownLatch cdl1 = new CountDownLatch(1);
            AtomicReference ref2 = new AtomicReference();
            CountDownLatch cdl2 = new CountDownLatch(1);
            w1.schedule(() -> {
                Object state = initial;
                while (!stopRace.test(state)) {
                    state = race.apply(state);
                    LockSupport.parkNanos(1L);
                }
                ref1.set(state);
                cdl1.countDown();
            });
            w2.schedule(() -> {
                Object state = initial;
                while (!stopRace.test(state)) {
                    state = race.apply(state);
                    LockSupport.parkNanos(1L);
                }
                ref2.set(state);
                cdl2.countDown();
            });
            try {
                cdl1.await();
                cdl2.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            boolean bl = terminate.test(ref1.get(), ref2.get());
            return bl;
        }
        finally {
            w1.dispose();
            w2.dispose();
        }
    }

    public static void race(Runnable ... rs) {
        RaceTestUtils.race(Schedulers.boundedElastic(), rs);
    }

    public static void race(Runnable r1, Runnable r2) {
        RaceTestUtils.race(new Runnable[]{r1, r2});
    }

    @Deprecated
    public static void race(Runnable r1, Runnable r2, Scheduler s) {
        RaceTestUtils.race(s, r1, r2);
    }

    public static void race(Scheduler s, Runnable ... rs) {
        RaceTestUtils.race(5, s, rs);
    }

    public static void race(int timeoutSeconds, Scheduler s, Runnable ... rs) {
        AtomicInteger count = new AtomicInteger(rs.length);
        CountDownLatch cdl = new CountDownLatch(rs.length);
        Throwable[] errors = new Throwable[rs.length];
        int i = 0;
        while (i < rs.length) {
            int index = i++;
            s.schedule(() -> {
                if (count.decrementAndGet() != 0) {
                    while (count.get() != 0) {
                        Thread.yield();
                    }
                }
                try {
                    try {
                        rs[index].run();
                    }
                    catch (Throwable ex) {
                        errors[index] = ex;
                    }
                }
                finally {
                    cdl.countDown();
                }
            });
        }
        try {
            if (!cdl.await(timeoutSeconds, TimeUnit.SECONDS)) {
                throw new AssertionError((Object)("RaceTestUtils.race wait timed out after " + timeoutSeconds + "s"));
            }
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
        ArrayList<Throwable> es = new ArrayList<Throwable>(rs.length);
        for (Throwable t : errors) {
            if (t == null) continue;
            es.add(t);
        }
        if (es.size() == 1) {
            throw Exceptions.propagate((Throwable)((Throwable)es.get(0)));
        }
        if (es.size() > 1) {
            throw Exceptions.multiple((Throwable[])es.toArray(new Throwable[0]));
        }
    }
}

