/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.bootstrap.triple;

import com.alipay.sofa.rpc.bootstrap.ConsumerBootstrap;
import com.alipay.sofa.rpc.bootstrap.DefaultConsumerBootstrap;
import com.alipay.sofa.rpc.bootstrap.triple.TripleClientProxyInvoker;
import com.alipay.sofa.rpc.client.ClientProxyInvoker;
import com.alipay.sofa.rpc.config.ConsumerConfig;
import com.alipay.sofa.rpc.ext.Extension;
import java.lang.reflect.Method;

@Extension(value="tri")
public class TripleConsumerBootstrap<T>
extends DefaultConsumerBootstrap<T> {
    public TripleConsumerBootstrap(ConsumerConfig<T> consumerConfig) {
        super(consumerConfig);
    }

    @Override
    public T refer() {
        Class<?> enclosingClass = this.getConsumerConfig().getProxyClass().getEnclosingClass();
        Method sofaStub = null;
        String serviceName = this.getConsumerConfig().getInterfaceId();
        try {
            sofaStub = enclosingClass.getDeclaredMethod("getServiceName", new Class[0]);
            serviceName = (String)sofaStub.invoke(null, new Object[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.getConsumerConfig().setVirtualInterfaceId(serviceName);
        return super.refer();
    }

    @Override
    protected ClientProxyInvoker buildClientProxyInvoker(ConsumerBootstrap bootstrap) {
        return new TripleClientProxyInvoker(bootstrap);
    }
}

