/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata.definition.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.dubbo.common.utils.StringUtils;

public class TypeDefinition
implements Serializable {
    private String type;
    private List<String> items;
    private List<String> enums;
    private Map<String, String> properties;

    public TypeDefinition() {
    }

    public TypeDefinition(String type) {
        this.setType(type);
    }

    public static String[] formatTypes(String[] types) {
        String[] newTypes = new String[types.length];
        for (int i = 0; i < types.length; ++i) {
            newTypes[i] = TypeDefinition.formatType(types[i]);
        }
        return newTypes;
    }

    public static String formatType(String type) {
        if (TypeDefinition.isGenericType(type)) {
            return TypeDefinition.formatGenericType(type);
        }
        return type;
    }

    private static String formatGenericType(String type) {
        return StringUtils.replace(type, ", ", ",");
    }

    private static boolean isGenericType(String type) {
        return type.contains("<") && type.contains(">");
    }

    public List<String> getEnums() {
        if (this.enums == null) {
            this.enums = new ArrayList<String>();
        }
        return this.enums;
    }

    public List<String> getItems() {
        if (this.items == null) {
            this.items = new ArrayList<String>();
        }
        return this.items;
    }

    public Map<String, String> getProperties() {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
        return this.properties;
    }

    public String getType() {
        return this.type;
    }

    public void setEnums(List<String> enums) {
        this.enums = enums;
    }

    public void setItems(List<String> items) {
        this.items = items;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public void setType(String type) {
        this.type = TypeDefinition.formatType(type);
    }

    public String toString() {
        return "TypeDefinition [type=" + this.type + ", properties=" + this.properties + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TypeDefinition)) {
            return false;
        }
        TypeDefinition that = (TypeDefinition)o;
        return Objects.equals(this.getType(), that.getType()) && Objects.equals(this.getItems(), that.getItems()) && Objects.equals(this.getEnums(), that.getEnums()) && Objects.equals(this.getProperties(), that.getProperties());
    }

    public int hashCode() {
        return Objects.hash(this.getType(), this.getItems(), this.getEnums(), this.getProperties());
    }
}

