/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.response;

import com.aliyun.openservices.log.common.LZ4Encoder;
import com.aliyun.openservices.log.common.LogGroupData;
import com.aliyun.openservices.log.exception.LogException;
import com.aliyun.openservices.log.response.Response;
import com.aliyun.openservices.log.util.Args;
import com.aliyun.openservices.log.util.VarintUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class PullLogsResponse
extends Response {
    private static final long serialVersionUID = -2027711570684362279L;
    private List<LogGroupData> logGroups;
    private int rawSize;
    private int count;
    private byte[] rawData;

    public PullLogsResponse(Map<String, String> headers, byte[] rawData) throws LogException {
        super(headers);
        this.rawData = rawData;
        try {
            this.rawSize = Integer.parseInt(headers.get("x-log-bodyrawsize"));
            this.count = Integer.parseInt(this.GetHeader("x-log-count"));
        }
        catch (NumberFormatException e) {
            throw new LogException("ParseLogGroupListRawSizeError", e.getMessage(), e, this.GetRequestId());
        }
    }

    public int getRawSize() {
        return this.rawSize;
    }

    private void parseLogGroupsIfNeeded() throws LogException {
        if (this.logGroups != null) {
            return;
        }
        this.logGroups = new ArrayList<LogGroupData>();
        if (this.rawSize > 0) {
            byte[] uncompressedData = LZ4Encoder.decompressFromLhLz4Chunk(this.rawData, this.rawSize);
            this.parseFastLogGroupList(uncompressedData);
        }
        if (this.logGroups.size() != this.count) {
            throw new LogException("LogGroupCountNotMatch", "LogGroup count does match with the count in header message", this.GetRequestId());
        }
    }

    private void parseFastLogGroupList(byte[] uncompressedData) throws LogException {
        int pos = 0;
        int rawSize = uncompressedData.length;
        while (pos < rawSize) {
            int[] value = VarintUtil.DecodeVarInt32(uncompressedData, pos, rawSize);
            if (value[0] == 0) {
                throw new LogException("InitLogGroupsError", "decode varint32 error", this.GetRequestId());
            }
            pos = value[2];
            int mode = value[1] & 7;
            int index = value[1] >> 3;
            if (mode == 0) {
                value = VarintUtil.DecodeVarInt32(uncompressedData, pos, rawSize);
                if (value[0] == 0) {
                    throw new LogException("InitLogGroupsError", "decode varint32 error", this.GetRequestId());
                }
                pos = value[2];
                continue;
            }
            if (mode == 1) {
                pos += 8;
                continue;
            }
            if (mode == 2) {
                value = VarintUtil.DecodeVarInt32(uncompressedData, pos, rawSize);
                if (value[0] == 0) {
                    throw new LogException("InitLogGroupsError", "decode varint32 error", this.GetRequestId());
                }
                if (index == 1) {
                    this.logGroups.add(new LogGroupData(uncompressedData, value[2], value[1], this.GetRequestId()));
                }
                pos = value[1] + value[2];
                continue;
            }
            if (mode == 5) {
                pos += 4;
                continue;
            }
            throw new LogException("InitLogGroupsError", "mode: " + mode, this.GetRequestId());
        }
        if (pos != rawSize) {
            throw new LogException("InitLogGroupsError", "parse LogGroupList fail", this.GetRequestId());
        }
    }

    public String getNextCursor() {
        return this.GetHeader("x-log-cursor");
    }

    public int getCount() {
        return this.count;
    }

    public LogGroupData getLogGroup(int index) throws LogException {
        Args.check(this.count > 0, "No LogGroups in response");
        Args.check(index >= 0 && index < this.count, "index out of range [0, " + this.count + ")");
        this.parseLogGroupsIfNeeded();
        return this.logGroups.get(index);
    }

    public List<LogGroupData> getLogGroups(int offset) throws LogException {
        Args.check(this.count > 0, "No LogGroups in response");
        Args.check(offset >= 0 && offset < this.count, "offset out of range [0, " + this.count + ")");
        this.parseLogGroupsIfNeeded();
        return this.logGroups.subList(offset, this.count);
    }

    public List<LogGroupData> getLogGroups() throws LogException {
        this.parseLogGroupsIfNeeded();
        return this.logGroups;
    }

    public byte[] getRawData() {
        return this.rawData;
    }
}

