/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.scala.collection;

import coursierapi.shaded.scala.Function1;
import coursierapi.shaded.scala.Tuple2;
import coursierapi.shaded.scala.collection.AbstractIterator;
import coursierapi.shaded.scala.collection.BitSet;
import coursierapi.shaded.scala.collection.IterableOnce;
import coursierapi.shaded.scala.collection.Iterator;
import coursierapi.shaded.scala.collection.Iterator$;
import coursierapi.shaded.scala.collection.Set;
import coursierapi.shaded.scala.collection.SortedSet;
import coursierapi.shaded.scala.collection.SortedSetOps;
import coursierapi.shaded.scala.collection.SpecificIterableFactory;
import coursierapi.shaded.scala.collection.immutable.Range;
import coursierapi.shaded.scala.math.Ordering;
import coursierapi.shaded.scala.math.Ordering$Int$;
import coursierapi.shaded.scala.runtime.BoxesRunTime;

public interface BitSetOps<C extends BitSet & BitSetOps<C>>
extends SortedSetOps<Object, SortedSet, C> {
    public /* synthetic */ int scala$collection$BitSetOps$$super$max(Ordering var1);

    public /* synthetic */ int scala$collection$BitSetOps$$super$min(Ordering var1);

    public /* synthetic */ BitSet scala$collection$BitSetOps$$super$concat(IterableOnce var1);

    public /* synthetic */ BitSet scala$collection$BitSetOps$$super$intersect(Set var1);

    public /* synthetic */ BitSet scala$collection$BitSetOps$$super$diff(Set var1);

    public SpecificIterableFactory<Object, C> bitSetFactory();

    public static /* synthetic */ Ordering ordering$(BitSetOps $this) {
        return $this.ordering();
    }

    @Override
    default public Ordering<Object> ordering() {
        return Ordering$Int$.MODULE$;
    }

    public int nwords();

    public long word(int var1);

    public C fromBitMaskNoCopy(long[] var1);

    public static /* synthetic */ boolean contains$(BitSetOps $this, int elem) {
        return $this.contains(elem);
    }

    @Override
    default public boolean contains(int elem) {
        return 0 <= elem && (this.word(elem >> 6) & 1L << elem) != 0L;
    }

    public static /* synthetic */ Iterator iterator$(BitSetOps $this) {
        return $this.iterator();
    }

    @Override
    default public Iterator<Object> iterator() {
        return this.iteratorFrom(0);
    }

    public static /* synthetic */ Iterator iteratorFrom$(BitSetOps $this, int start) {
        return $this.iteratorFrom(start);
    }

    default public Iterator<Object> iteratorFrom(int start) {
        return new AbstractIterator<Object>(this, start){
            private int currentPos;
            private long currentWord;
            private final /* synthetic */ BitSetOps $outer;

            public final boolean hasNext() {
                while (this.currentWord == 0L) {
                    if (this.currentPos + 1 >= this.$outer.nwords()) {
                        return false;
                    }
                    ++this.currentPos;
                    this.currentWord = this.$outer.word(this.currentPos);
                }
                return true;
            }

            public final int next() {
                if (this.hasNext()) {
                    int bitPos = Long.numberOfTrailingZeros(this.currentWord);
                    this.currentWord &= this.currentWord - 1L;
                    return (this.currentPos << 6) + bitPos;
                }
                return BoxesRunTime.unboxToInt(Iterator$.scala$collection$Iterator$$_empty.next());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.currentPos = start$1 > 0 ? start$1 >> 6 : 0;
                this.currentWord = start$1 > 0 ? $outer.word(this.currentPos) & -1L << (start$1 & 0x3F) : $outer.word(0);
            }
        };
    }

    public static /* synthetic */ int size$(BitSetOps $this) {
        return $this.size();
    }

    @Override
    default public int size() {
        int s = 0;
        int i = this.nwords();
        while (i > 0) {
            s += Long.bitCount(this.word(--i));
        }
        return s;
    }

    public static /* synthetic */ boolean isEmpty$(BitSetOps $this) {
        return $this.isEmpty();
    }

    @Override
    default public boolean isEmpty() {
        int n = 0;
        int until$extension_end = this.nwords();
        return new Range.Exclusive(n, until$extension_end, 1).forall(i -> this.word(i) == 0L);
    }

    public static /* synthetic */ int max$(BitSetOps $this, Ordering ord) {
        return $this.max(ord);
    }

    @Override
    default public <B> int max(Ordering<B> ord) {
        if (Ordering$Int$.MODULE$ == ord) {
            for (int largestInt_i = this.nwords() - 1; largestInt_i >= 0; --largestInt_i) {
                long largestInt_currentWord = this.word(largestInt_i);
                if (largestInt_currentWord == 0L) continue;
                return (largestInt_i + 1) * 64 - Long.numberOfLeadingZeros(largestInt_currentWord) - 1;
            }
            throw new UnsupportedOperationException("empty.largestInt");
        }
        if (Ordering.CachedReverse.isReverseOf$(Ordering$Int$.MODULE$, ord)) {
            int smallestInt_thisnwords = this.nwords();
            for (int smallestInt_i = 0; smallestInt_i < smallestInt_thisnwords; ++smallestInt_i) {
                long smallestInt_currentWord = this.word(smallestInt_i);
                if (smallestInt_currentWord == 0L) continue;
                return Long.numberOfTrailingZeros(smallestInt_currentWord) + smallestInt_i * 64;
            }
            throw new UnsupportedOperationException("empty.smallestInt");
        }
        return this.scala$collection$BitSetOps$$super$max(ord);
    }

    public static /* synthetic */ int min$(BitSetOps $this, Ordering ord) {
        return $this.min(ord);
    }

    @Override
    default public <B> int min(Ordering<B> ord) {
        if (Ordering$Int$.MODULE$ == ord) {
            int smallestInt_thisnwords = this.nwords();
            for (int smallestInt_i = 0; smallestInt_i < smallestInt_thisnwords; ++smallestInt_i) {
                long smallestInt_currentWord = this.word(smallestInt_i);
                if (smallestInt_currentWord == 0L) continue;
                return Long.numberOfTrailingZeros(smallestInt_currentWord) + smallestInt_i * 64;
            }
            throw new UnsupportedOperationException("empty.smallestInt");
        }
        if (Ordering.CachedReverse.isReverseOf$(Ordering$Int$.MODULE$, ord)) {
            for (int largestInt_i = this.nwords() - 1; largestInt_i >= 0; --largestInt_i) {
                long largestInt_currentWord = this.word(largestInt_i);
                if (largestInt_currentWord == 0L) continue;
                return (largestInt_i + 1) * 64 - Long.numberOfLeadingZeros(largestInt_currentWord) - 1;
            }
            throw new UnsupportedOperationException("empty.largestInt");
        }
        return this.scala$collection$BitSetOps$$super$min(ord);
    }

    public static /* synthetic */ void foreach$(BitSetOps $this, Function1 f) {
        $this.foreach(f);
    }

    @Override
    default public <U> void foreach(Function1<Object, U> f) {
        for (int i = 0; i < this.nwords(); ++i) {
            long w = this.word(i);
            int j = i * 64;
            while (w != 0L) {
                if ((w & 1L) == 1L) {
                    f.apply(j);
                }
                w >>>= 1;
                ++j;
            }
        }
    }

    public static /* synthetic */ BitSet concat$(BitSetOps $this, IterableOnce other) {
        return $this.concat(other);
    }

    @Override
    default public C concat(IterableOnce<Object> other) {
        if (other instanceof BitSet) {
            BitSet bitSet = (BitSet)other;
            int n = ((BitSetOps)this.coll()).nwords();
            int max$extension_that = bitSet.nwords();
            int len = Math.max(n, max$extension_that);
            long[] words = new long[len];
            int n2 = 0;
            Range.Exclusive foreach$mVc$sp_this = new Range.Exclusive(n2, len, 1);
            if (!foreach$mVc$sp_this.isEmpty()) {
                int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
                while (true) {
                    words[foreach$mVc$sp_i] = this.word(foreach$mVc$sp_i) | bitSet.word(foreach$mVc$sp_i);
                    if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement) break;
                    foreach$mVc$sp_i += foreach$mVc$sp_this.step();
                }
            }
            Object var7_8 = null;
            return this.fromBitMaskNoCopy(words);
        }
        return (C)this.scala$collection$BitSetOps$$super$concat(other);
    }

    public static /* synthetic */ BitSet intersect$(BitSetOps $this, Set other) {
        return $this.intersect(other);
    }

    @Override
    default public C intersect(Set<Object> other) {
        if (other instanceof BitSet) {
            BitSet bitSet = (BitSet)other;
            int n = ((BitSetOps)this.coll()).nwords();
            int min$extension_that = bitSet.nwords();
            int len = Math.min(n, min$extension_that);
            long[] words = new long[len];
            int n2 = 0;
            Range.Exclusive foreach$mVc$sp_this = new Range.Exclusive(n2, len, 1);
            if (!foreach$mVc$sp_this.isEmpty()) {
                int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
                while (true) {
                    words[foreach$mVc$sp_i] = this.word(foreach$mVc$sp_i) & bitSet.word(foreach$mVc$sp_i);
                    if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement) break;
                    foreach$mVc$sp_i += foreach$mVc$sp_this.step();
                }
            }
            Object var7_8 = null;
            return this.fromBitMaskNoCopy(words);
        }
        return (C)this.scala$collection$BitSetOps$$super$intersect(other);
    }

    public static /* synthetic */ BitSet diff$(BitSetOps $this, Set other) {
        return $this.diff(other);
    }

    @Override
    default public C diff(Set<Object> other) {
        if (other instanceof BitSet) {
            BitSet bitSet = (BitSet)other;
            int len = ((BitSetOps)this.coll()).nwords();
            long[] words = new long[len];
            int n = 0;
            Range.Exclusive foreach$mVc$sp_this = new Range.Exclusive(n, len, 1);
            if (!foreach$mVc$sp_this.isEmpty()) {
                int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
                while (true) {
                    words[foreach$mVc$sp_i] = this.word(foreach$mVc$sp_i) & (bitSet.word(foreach$mVc$sp_i) ^ 0xFFFFFFFFFFFFFFFFL);
                    if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement) break;
                    foreach$mVc$sp_i += foreach$mVc$sp_this.step();
                }
            }
            Object var6_6 = null;
            return this.fromBitMaskNoCopy(words);
        }
        return (C)this.scala$collection$BitSetOps$$super$diff(other);
    }

    public static /* synthetic */ Tuple2 partition$(BitSetOps $this, Function1 p) {
        return $this.partition(p);
    }

    @Override
    default public Tuple2<C, C> partition(Function1<Object, Object> p) {
        BitSet left = (BitSet)this.filter(p);
        return new Tuple2(left, this.diff(left));
    }
}

