/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.artifact;

import jakarta.ws.rs.core.UriBuilder;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.ref.Cleaner;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.apache.commons.io.FilenameUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.spark.JobArtifactSet$;
import org.apache.spark.JobArtifactState;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkException$;
import org.apache.spark.SparkRuntimeException;
import org.apache.spark.SparkRuntimeException$;
import org.apache.spark.SparkUnsupportedOperationException;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.internal.config.package$;
import org.apache.spark.sql.Artifact;
import org.apache.spark.sql.artifact.ArtifactManager$;
import org.apache.spark.sql.artifact.ArtifactManager$SparkContextResourceType$;
import org.apache.spark.sql.artifact.ArtifactStateForCleanup;
import org.apache.spark.sql.artifact.RefCountedCacheId;
import org.apache.spark.sql.classic.SparkSession;
import org.apache.spark.sql.internal.NonClosableMutableURLClassLoader;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.util.ArtifactUtils$;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockManager;
import org.apache.spark.storage.CacheId;
import org.apache.spark.storage.StorageLevel$;
import org.apache.spark.util.ChildFirstURLClassLoader;
import org.apache.spark.util.StubClassLoader$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\r-d\u0001\u0002*T\u0001yC\u0001\u0002\u001d\u0001\u0003\u0002\u0003\u0006I!\u001d\u0005\u0006o\u0002!\t\u0001\u001f\u0005\u0006y\u0002!\t\" \u0005\f\u0003\u001b\u0001\u0001R1A\u0005\u0002M\u000by\u0001\u0003\u0007\u0002,\u0001\u0001\n\u0011aA!\u0002\u0013\ti\u0003C\u0005\u00026\u0001\u0011\r\u0011\"\u0005T{\"9\u0011q\u0007\u0001!\u0002\u0013q\bBCA\u001d\u0001\t\u0007I\u0011C*\u0002\u0010!A\u00111\b\u0001!\u0002\u0013\t\t\u0002\u0003\u0007\u0002>\u0001\u0001\n\u0011aA!\u0002\u0013\ti\u0003C\u0005\u0002@\u0001\u0011\r\u0011\"\u0005T{\"9\u0011\u0011\t\u0001!\u0002\u0013q\bBCA\"\u0001\t\u0007I\u0011C*\u0002\u0010!A\u0011Q\t\u0001!\u0002\u0013\t\t\u0002\u0003\u0006\u0002H\u0001A)\u0019!C\u0005\u0003\u0013B!\"!\u0015\u0001\u0011\u000b\u0007I\u0011BA%\u0011-\t\u0019\u0006\u0001EC\u0002\u0013EQ+!\u0016\t\u0013\u0005}\u0003A1A\u0005\u0012\u0005\u0005\u0004\u0002CA<\u0001\u0001\u0006I!a\u0019\t\u0013\u0005e\u0004\u00011A\u0005\u0012\u0005m\u0004\"CAE\u0001\u0001\u0007I\u0011CAF\u0011!\t)\n\u0001Q!\n\u0005u\u0004bBAP\u0001\u0011%\u0011\u0011\u0015\u0005\b\u0003\u000b\u0004A\u0011AAd\u0011%\t\u0019\u000e\u0001b\u0001\n\u0013\t)\u000e\u0003\u0005\u0002f\u0002\u0001\u000b\u0011BAl\u0011%\t9\u000f\u0001b\u0001\n#\tI\u000f\u0003\u0005\u0002r\u0002\u0001\u000b\u0011BAv\u0011%\t\u0019\u0010\u0001b\u0001\n#\t)\u0010\u0003\u0005\u0002z\u0002\u0001\u000b\u0011BA|\u0011%\tY\u0010\u0001b\u0001\n#\ti\u0010\u0003\u0005\u0003\u0010\u0002\u0001\u000b\u0011BA\u0000\u0011\u001d\u0011\t\n\u0001C\u0001\u0005'CqAa-\u0001\t\u0003\u0011)\f\u0003\u0005\u0003:\u0002!\t\"\u0016B^\u0011\u001d\u0011y\r\u0001C\u0005\u0005#D\u0011Ba9\u0001#\u0003%IA!:\t\u0013\tm\b!%A\u0005\n\t\u0015\bb\u0002B\u007f\u0001\u0011%!q \u0005\b\u0007\u000b\u0001A\u0011AB\u0004\u0011%\u0019I\u0002AI\u0001\n\u0003\u0011)\u000f\u0003\u0005\u0004\u001c\u0001!\t!VB\u000f\u0011\u001d\u0019i\u0003\u0001C\u0001\u0007_Aqa!\r\u0001\t\u0013\u0019y\u0003\u0003\u0005\u00044\u0001!\t!VB\u001b\u0011%\u0019Y\u0004\u0001b\u0001\n\u0013\u0019i\u0004\u0003\u0005\u0004@\u0001\u0001\u000b\u0011\u0002B3\u0011\u001d\u0019\t\u0005\u0001C\u0005\u0007\u0007B\u0011ba\u0015\u0001\u0001\u0004%Iaa\u0011\t\u0013\rU\u0003\u00011A\u0005\n\r]\u0003\u0002CB.\u0001\u0001\u0006Ka!\u0012\t\u000f\ru\u0003\u0001\"\u0003\u0003t!91q\f\u0001\u0005B\tM\u0004\u0002CB1\u0001\u0011\u0005QKa\u001d\t\u000f\r\r\u0004\u0001\"\u0001\u0004f\u001d9!QB*\t\u0002\t=aA\u0002*T\u0011\u0003\u0011\t\u0002\u0003\u0004xs\u0011\u0005!\u0011\u0004\u0005\n\u00057I$\u0019!C\u0001\u0005;A\u0001Ba\t:A\u0003%!q\u0004\u0005\n\u0005KI$\u0019!C\u0001\u0005;A\u0001Ba\n:A\u0003%!q\u0004\u0005\u000b\u0005SI\u0004R1A\u0005\u0002Mkx\u0001\u0003B\u0016s!\u00051K!\f\u0007\u0011\tE\u0012\b#\u0001T\u0005gAaa^!\u0005\u0002\tmRA\u0002B\u001f\u0003\u0002\u0011y\u0004C\u0005\u0003H\u0005\u0013\r\u0011\"\u0001\u0003J!A!1J!!\u0002\u0013\u0011y\u0004C\u0005\u0003N\u0005\u0013\r\u0011\"\u0001\u0003J!A!qJ!!\u0002\u0013\u0011y\u0004C\u0005\u0003R\u0005\u0013\r\u0011\"\u0001\u0003J!A!1K!!\u0002\u0013\u0011y\u0004C\u0005\u0003V\u0005\u000b\t\u0011\"\u0003\u0003X\u00191!\u0011L\u001d\u0005\u00057B!Ba\u0019L\u0005\u0003\u0005\u000b\u0011\u0002B3\u0011\u001998\n\"\u0001\u0003l!9!\u0011O&\u0005B\tM\u0004\"\u0003B;s\t\u0007I\u0011\u0002B<\u0011!\u0011))\u000fQ\u0001\n\te\u0004b\u0002BDs\u0011%!\u0011\u0012\u0002\u0010\u0003J$\u0018NZ1di6\u000bg.Y4fe*\u0011A+V\u0001\tCJ$\u0018NZ1di*\u0011akV\u0001\u0004gFd'B\u0001-Z\u0003\u0015\u0019\b/\u0019:l\u0015\tQ6,\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u00029\u0006\u0019qN]4\u0004\u0001M!\u0001aX4k!\t\u0001W-D\u0001b\u0015\t\u00117-\u0001\u0003mC:<'\"\u00013\u0002\t)\fg/Y\u0005\u0003M\u0006\u0014aa\u00142kK\u000e$\bC\u00011i\u0013\tI\u0017MA\u0007BkR|7\t\\8tK\u0006\u0014G.\u001a\t\u0003W:l\u0011\u0001\u001c\u0006\u0003[^\u000b\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003_2\u0014q\u0001T8hO&tw-A\u0004tKN\u001c\u0018n\u001c8\u0011\u0005I,X\"A:\u000b\u0005Q,\u0016aB2mCN\u001c\u0018nY\u0005\u0003mN\u0014Ab\u00159be.\u001cVm]:j_:\fa\u0001P5oSRtDCA=|!\tQ\b!D\u0001T\u0011\u0015\u0001(\u00011\u0001r\u0003A\t'\u000f^5gC\u000e$(k\\8u!\u0006$\b.F\u0001\u007f!\ry\u0018\u0011B\u0007\u0003\u0003\u0003QA!a\u0001\u0002\u0006\u0005!a-\u001b7f\u0015\r\t9aY\u0001\u0004]&|\u0017\u0002BA\u0006\u0003\u0003\u0011A\u0001U1uQ\u0006y\u0011M\u001d;jM\u0006\u001cGOU8piV\u0013\u0016*\u0006\u0002\u0002\u0012A!\u00111CA\u0013\u001d\u0011\t)\"!\t\u0011\t\u0005]\u0011QD\u0007\u0003\u00033Q1!a\u0007^\u0003\u0019a$o\\8u})\u0011\u0011qD\u0001\u0006g\u000e\fG.Y\u0005\u0005\u0003G\ti\"\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003O\tIC\u0001\u0004TiJLgn\u001a\u0006\u0005\u0003G\ti\"A\u0002yIE\u0002r!a\f\u00022y\f\t\"\u0004\u0002\u0002\u001e%!\u00111GA\u000f\u0005\u0019!V\u000f\u001d7fe\u0005a\u0011M\u001d;jM\u0006\u001cG\u000fU1uQ\u0006i\u0011M\u001d;jM\u0006\u001cG\u000fU1uQ\u0002\n1\"\u0019:uS\u001a\f7\r^+S\u0013\u0006a\u0011M\u001d;jM\u0006\u001cG/\u0016*JA\u0005\u0019\u0001\u0010\n\u001a\u0002\u0011\rd\u0017m]:ESJ\f\u0011b\u00197bgN$\u0015N\u001d\u0011\u0002\u0019I,\u0007\u000f\\\"mCN\u001cXKU%\u0002\u001bI,\u0007\u000f\\\"mCN\u001cXKU%!\u0003Y\tGn^1zg\u0006\u0003\b\u000f\\=DY\u0006\u001c8\u000fT8bI\u0016\u0014XCAA&!\u0011\ty#!\u0014\n\t\u0005=\u0013Q\u0004\u0002\b\u0005>|G.Z1o\u0003=\u0019Xm]:j_:L5o\u001c7bi\u0016$\u0017!B:uCR,WCAA,!\u0011\tI&a\u0017\u000e\u0003]K1!!\u0018X\u0005AQuNY!si&4\u0017m\u0019;Ti\u0006$X-\u0001\u000btKN\u001c\u0018n\u001c8BeRLg-Y2u\u0003\u0012$W\rZ\u000b\u0003\u0003G\u0002B!!\u001a\u0002t5\u0011\u0011q\r\u0006\u0005\u0003S\nY'\u0001\u0004bi>l\u0017n\u0019\u0006\u0005\u0003[\ny'\u0001\u0006d_:\u001cWO\u001d:f]RT1!!\u001dd\u0003\u0011)H/\u001b7\n\t\u0005U\u0014q\r\u0002\u000e\u0003R|W.[2C_>dW-\u00198\u0002+M,7o]5p]\u0006\u0013H/\u001b4bGR\fE\rZ3eA\u0005\t2-Y2iK\u0012\u001cE.Y:t\u0019>\fG-\u001a:\u0016\u0005\u0005u\u0004CBA\u0018\u0003\u007f\n\u0019)\u0003\u0003\u0002\u0002\u0006u!AB(qi&|g\u000eE\u0002a\u0003\u000bK1!a\"b\u0005-\u0019E.Y:t\u0019>\fG-\u001a:\u0002+\r\f7\r[3e\u00072\f7o\u001d'pC\u0012,'o\u0018\u0013fcR!\u0011QRAJ!\u0011\ty#a$\n\t\u0005E\u0015Q\u0004\u0002\u0005+:LG\u000fC\u0005\u0002,U\t\t\u00111\u0001\u0002~\u0005\u00112-Y2iK\u0012\u001cE.Y:t\u0019>\fG-\u001a:!Q\r1\u0012\u0011\u0014\t\u0005\u0003_\tY*\u0003\u0003\u0002\u001e\u0006u!\u0001\u0003<pY\u0006$\u0018\u000e\\3\u0002/]LG\u000f[\"mCN\u001cHj\\1eKJLeMT3fI\u0016$W\u0003BAR\u0003S#B!!*\u0002<B!\u0011qUAU\u0019\u0001!q!a+\u0018\u0005\u0004\tiKA\u0001U#\u0011\ty+!.\u0011\t\u0005=\u0012\u0011W\u0005\u0005\u0003g\u000biBA\u0004O_RD\u0017N\\4\u0011\t\u0005=\u0012qW\u0005\u0005\u0003s\u000biBA\u0002B]fD\u0001\"!0\u0018\t\u0003\u0007\u0011qX\u0001\u0002MB1\u0011qFAa\u0003KKA!a1\u0002\u001e\tAAHY=oC6,g(A\u0007xSRD'+Z:pkJ\u001cWm]\u000b\u0005\u0003\u0013\fi\r\u0006\u0003\u0002L\u0006=\u0007\u0003BAT\u0003\u001b$q!a+\u0019\u0005\u0004\ti\u000b\u0003\u0005\u0002>b!\t\u0019AAi!\u0019\ty#!1\u0002L\u0006\t\u0002.Y:i)>\u001c\u0015m\u00195fI&#W*\u00199\u0016\u0005\u0005]\u0007\u0003CAm\u00037\f\t\"a8\u000e\u0005\u0005-\u0014\u0002BAo\u0003W\u0012\u0011cQ8oGV\u0014(/\u001a8u\u0011\u0006\u001c\b.T1q!\rQ\u0018\u0011]\u0005\u0004\u0003G\u001c&!\u0005*fM\u000e{WO\u001c;fI\u000e\u000b7\r[3JI\u0006\u0011\u0002.Y:i)>\u001c\u0015m\u00195fI&#W*\u00199!\u0003!Q\u0017M]:MSN$XCAAv!\u0015\tI.!<\u007f\u0013\u0011\ty/a\u001b\u0003)\r{\u0007/_(o/JLG/Z!se\u0006LH*[:u\u0003%Q\u0017M]:MSN$\b%A\tqsRDwN\\%oG2,H-\u001a'jgR,\"!a>\u0011\r\u0005e\u0017Q^A\t\u0003I\u0001\u0018\u0010\u001e5p]&s7\r\\;eK2K7\u000f\u001e\u0011\u00023M\u0004\u0018M]6D_:$X\r\u001f;SK2\fG/\u001b<f!\u0006$\bn]\u000b\u0003\u0003\u007f\u0004b!!7\u0002n\n\u0005\u0001#CA\u0018\u0005\u0007\u00119A BG\u0013\u0011\u0011)!!\b\u0003\rQ+\b\u000f\\34!\r\u0011Ia\u0011\b\u0004\u0005\u0017\u0001eB\u0001>9\u0003=\t%\u000f^5gC\u000e$X*\u00198bO\u0016\u0014\bC\u0001>:'\u0011I$1\u00036\u0011\t\u0005=\"QC\u0005\u0005\u0005/\tiB\u0001\u0004B]f\u0014VM\u001a\u000b\u0003\u0005\u001f\t\u0011CZ8so\u0006\u0014H\rV8G'B\u0013XMZ5y+\t\u0011y\u0002E\u0002a\u0005CI1!a\nb\u0003I1wN]<be\u0012$vNR*Qe\u00164\u0017\u000e\u001f\u0011\u00023\u0005\u0013F+\u0013$B\u0007R{F)\u0013*F\u0007R{%+W0Q%\u00163\u0015\nW\u0001\u001b\u0003J#\u0016JR!D)~#\u0015JU#D)>\u0013\u0016l\u0018)S\u000b\u001aK\u0005\fI\u0001\u0016CJ$\u0018NZ1diJ{w\u000e\u001e#je\u0016\u001cGo\u001c:z\u0003a\u0019\u0006/\u0019:l\u0007>tG/\u001a=u%\u0016\u001cx.\u001e:dKRK\b/\u001a\t\u0004\u0005_\tU\"A\u001d\u00031M\u0003\u0018M]6D_:$X\r\u001f;SKN|WO]2f)f\u0004XmE\u0002B\u0005k\u0001B!a\f\u00038%!!\u0011HA\u000f\u0005-)e.^7fe\u0006$\u0018n\u001c8\u0015\u0005\t5\"\u0001\u0004*fg>,(oY3UsB,\u0007\u0003\u0002B!\u0005\u0007j\u0011!Q\u0005\u0005\u0005\u000b\u00129DA\u0003WC2,X-A\u0002K\u0003J+\"Aa\u0010\u0002\t)\u000b%\u000bI\u0001\u0005\r&cU)A\u0003G\u00132+\u0005%A\u0004B%\u000eC\u0015JV#\u0002\u0011\u0005\u00136\tS%W\u000b\u0002\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\u0012a\u0018\u0002\u0013'R\fG/Z\"mK\u0006tW\u000f\u001d*v]:,'o\u0005\u0003L?\nu\u0003c\u00011\u0003`%\u0019!\u0011M1\u0003\u0011I+hN\\1cY\u0016\fAb\u00197fC:,\bo\u0015;bi\u0016\u00042A\u001fB4\u0013\r\u0011Ig\u0015\u0002\u0018\u0003J$\u0018NZ1diN#\u0018\r^3G_J\u001cE.Z1okB$BA!\u001c\u0003pA\u0019!qF&\t\u000f\t\rT\n1\u0001\u0003f\u0005\u0019!/\u001e8\u0015\u0005\u00055\u0015aB2mK\u0006tWM]\u000b\u0003\u0005s\u0002BAa\u001f\u0003\u00026\u0011!Q\u0010\u0006\u0004\u0005\u007f\n\u0017a\u0001:fM&!!1\u0011B?\u0005\u001d\u0019E.Z1oKJ\f\u0001b\u00197fC:,'\u000fI\u0001\u0017G2,\u0017M\\+q\u000f2|'-\u00197SKN|WO]2fgR!\u0011Q\u0012BF\u0011\u001d\u0011\u0019'\u0015a\u0001\u0005K\u0002b!a\f\u0002\u0000\u0005E\u0011AG:qCJ\\7i\u001c8uKb$(+\u001a7bi&4X\rU1uQN\u0004\u0013\u0001D4fi\u0006#G-\u001a3KCJ\u001cXC\u0001BK!\u0019\u00119J!)\u0003(:!!\u0011\u0014BO\u001d\u0011\t9Ba'\n\u0005\u0005}\u0011\u0002\u0002BP\u0003;\tq\u0001]1dW\u0006<W-\u0003\u0003\u0003$\n\u0015&aA*fc*!!qTA\u000f!\u0011\u0011IKa,\u000e\u0005\t-&b\u0001BWG\u0006\u0019a.\u001a;\n\t\tE&1\u0016\u0002\u0004+Jc\u0015!E4fiBKH\u000f[8o\u0013:\u001cG.\u001e3fgV\u0011!q\u0017\t\u0007\u0005/\u0013\t+!\u0005\u0002!\u001d,GoQ1dQ\u0016$'\t\\8dW&#G\u0003\u0002B_\u0005\u0017\u0004b!a\f\u0002\u0000\t}\u0006\u0003\u0002Ba\u0005\u000fl!Aa1\u000b\u0007\t\u0015w+A\u0004ti>\u0014\u0018mZ3\n\t\t%'1\u0019\u0002\b\u0007\u0006\u001c\u0007.Z%e\u0011\u001d\u0011im\ta\u0001\u0003#\tA\u0001[1tQ\u0006aAO]1og\u001a,'OR5mKRQ\u0011Q\u0012Bj\u0005/\u0014YNa8\t\r\tUG\u00051\u0001\u007f\u0003\u0019\u0019x.\u001e:dK\"1!\u0011\u001c\u0013A\u0002y\fa\u0001^1sO\u0016$\b\"\u0003BoIA\u0005\t\u0019AA&\u00039\tG\u000e\\8x\u001fZ,'o\u001e:ji\u0016D\u0011B!9%!\u0003\u0005\r!a\u0013\u0002\u0019\u0011,G.\u001a;f'>,(oY3\u0002-Q\u0014\u0018M\\:gKJ4\u0015\u000e\\3%I\u00164\u0017-\u001e7uIM*\"Aa:+\t\u0005-#\u0011^\u0016\u0003\u0005W\u0004BA!<\u0003x6\u0011!q\u001e\u0006\u0005\u0005c\u0014\u00190A\u0005v]\u000eDWmY6fI*!!Q_A\u000f\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005s\u0014yOA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fa\u0003\u001e:b]N4WM\u001d$jY\u0016$C-\u001a4bk2$H\u0005N\u0001\u000e]>\u0014X.\u00197ju\u0016\u0004\u0016\r\u001e5\u0015\u0007y\u001c\t\u0001\u0003\u0004\u0004\u0004\u001d\u0002\rA`\u0001\u0005a\u0006$\b.A\u0006bI\u0012\f%\u000f^5gC\u000e$HCCAG\u0007\u0013\u0019ia!\u0005\u0004\u0016!111\u0002\u0015A\u0002y\f!C]3n_R,'+\u001a7bi&4X\rU1uQ\"11q\u0002\u0015A\u0002y\fac]3sm\u0016\u0014Hj\\2bYN#\u0018mZ5oOB\u000bG\u000f\u001b\u0005\b\u0007'A\u0003\u0019\u0001BG\u0003!1'/Y4nK:$\b\"CB\fQA\u0005\t\u0019AA&\u0003A!W\r\\3uKN#\u0018mZ3e\r&dW-A\u000bbI\u0012\f%\u000f^5gC\u000e$H\u0005Z3gCVdG\u000f\n\u001b\u0002#\u0005$G\rT8dC2\f%\u000f^5gC\u000e$8\u000f\u0006\u0003\u0002\u000e\u000e}\u0001bBB\u0011U\u0001\u000711E\u0001\nCJ$\u0018NZ1diN\u0004bAa&\u0003\"\u000e\u0015\u0002\u0003BB\u0014\u0007Si\u0011!V\u0005\u0004\u0007W)&\u0001C!si&4\u0017m\u0019;\u0002\u0017\rd\u0017m]:m_\u0006$WM]\u000b\u0003\u0003\u0007\u000b\u0001CY;jY\u0012\u001cE.Y:t\u0019>\fG-\u001a:\u0002\u000b\rdwN\\3\u0015\u0007e\u001c9\u0004\u0003\u0004\u0004:5\u0002\r!]\u0001\u000b]\u0016<8+Z:tS>t\u0017AH2mK\u0006tW\u000b]*uCR,gi\u001c:HY>\u0014\u0017\r\u001c*fg>,(oY3t+\t\u0011)'A\u0010dY\u0016\fg.\u00169Ti\u0006$XMR8s\u000f2|'-\u00197SKN|WO]2fg\u0002\nAbZ3u\u00072,\u0017M\\1cY\u0016,\"a!\u0012\u0011\t\r\u001d3Q\n\b\u0005\u0005w\u001aI%\u0003\u0003\u0004L\tu\u0014aB\"mK\u0006tWM]\u0005\u0005\u0007\u001f\u001a\tFA\u0005DY\u0016\fg.\u00192mK*!11\nB?\u0003%\u0019G.Z1oC\ndW-A\u0007dY\u0016\fg.\u00192mK~#S-\u001d\u000b\u0005\u0003\u001b\u001bI\u0006C\u0005\u0002,I\n\t\u00111\u0001\u0004F\u0005Q1\r\\3b]\u0006\u0014G.\u001a\u0011\u0002!\rdW-\u00198VaJ+7o\\;sG\u0016\u001c\u0018!B2m_N,\u0017AG2mK\u0006tW\u000b\u001d*fg>,(oY3t\r>\u0014H+Z:uS:<\u0017AE;qY>\fG-\u0011:uS\u001a\f7\r\u001e+p\rN$b!!$\u0004h\r%\u0004BBB\u0006o\u0001\u0007a\u0010\u0003\u0004\u0004\u0010]\u0002\rA ")
public class ArtifactManager
implements AutoCloseable,
Logging {
    private String artifactRootURI;
    private boolean alwaysApplyClassLoader;
    private boolean sessionIsolated;
    private JobArtifactState state;
    private final SparkSession session;
    private final /* synthetic */ Tuple2 x$1;
    private final Path artifactPath;
    private final String artifactURI;
    private final /* synthetic */ Tuple2 x$2;
    private final Path classDir;
    private final String replClassURI;
    private final AtomicBoolean sessionArtifactAdded;
    private volatile Option<ClassLoader> cachedClassLoader;
    private final ConcurrentHashMap<String, RefCountedCacheId> hashToCachedIdMap;
    private final CopyOnWriteArrayList<Path> jarsList;
    private final CopyOnWriteArrayList<String> pythonIncludeList;
    private final CopyOnWriteArrayList<Tuple3<Enumeration.Value, Path, Option<String>>> sparkContextRelativePaths;
    private final ArtifactStateForCleanup cleanUpStateForGlobalResources;
    private Cleaner.Cleanable cleanable;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile byte bitmap$0;

    public static String ARTIFACT_DIRECTORY_PREFIX() {
        return ArtifactManager$.MODULE$.ARTIFACT_DIRECTORY_PREFIX();
    }

    public static String forwardToFSPrefix() {
        return ArtifactManager$.MODULE$.forwardToFSPrefix();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Path artifactRootPath() {
        return ArtifactManager$.MODULE$.artifactRootDirectory();
    }

    private String artifactRootURI$lzycompute() {
        ArtifactManager artifactManager = this;
        synchronized (artifactManager) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.artifactRootURI = SparkEnv$.MODULE$.get().rpcEnv().fileServer().addDirectoryIfAbsent(ArtifactManager$.MODULE$.ARTIFACT_DIRECTORY_PREFIX(), this.artifactRootPath().toFile());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.artifactRootURI;
    }

    public String artifactRootURI() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.artifactRootURI$lzycompute();
        }
        return this.artifactRootURI;
    }

    public Path artifactPath() {
        return this.artifactPath;
    }

    public String artifactURI() {
        return this.artifactURI;
    }

    public Path classDir() {
        return this.classDir;
    }

    public String replClassURI() {
        return this.replClassURI;
    }

    private boolean alwaysApplyClassLoader$lzycompute() {
        ArtifactManager artifactManager = this;
        synchronized (artifactManager) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.alwaysApplyClassLoader = StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(this.session.conf().get(SQLConf$.MODULE$.ARTIFACTS_SESSION_ISOLATION_ALWAYS_APPLY_CLASSLOADER().key())));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.alwaysApplyClassLoader;
    }

    private boolean alwaysApplyClassLoader() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.alwaysApplyClassLoader$lzycompute();
        }
        return this.alwaysApplyClassLoader;
    }

    private boolean sessionIsolated$lzycompute() {
        ArtifactManager artifactManager = this;
        synchronized (artifactManager) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.sessionIsolated = StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(this.session.conf().get(SQLConf$.MODULE$.ARTIFACTS_SESSION_ISOLATION_ENABLED().key())));
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.sessionIsolated;
    }

    private boolean sessionIsolated() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.sessionIsolated$lzycompute();
        }
        return this.sessionIsolated;
    }

    private JobArtifactState state$lzycompute() {
        ArtifactManager artifactManager = this;
        synchronized (artifactManager) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.state = this.sessionIsolated() ? new JobArtifactState(this.session.sessionUUID(), (Option)new Some((Object)this.replClassURI())) : null;
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.state;
    }

    public JobArtifactState state() {
        if ((byte)(this.bitmap$0 & 8) == 0) {
            return this.state$lzycompute();
        }
        return this.state;
    }

    public AtomicBoolean sessionArtifactAdded() {
        return this.sessionArtifactAdded;
    }

    public Option<ClassLoader> cachedClassLoader() {
        return this.cachedClassLoader;
    }

    public void cachedClassLoader_$eq(Option<ClassLoader> x$1) {
        this.cachedClassLoader = x$1;
    }

    private <T> T withClassLoaderIfNeeded(Function0<T> f) {
        String log = " classloader for session " + this.session.sessionUUID() + " because alwaysApplyClassLoader=" + this.alwaysApplyClassLoader() + ", sessionArtifactAdded=" + this.sessionArtifactAdded().get() + ".";
        if (this.alwaysApplyClassLoader() || this.sessionArtifactAdded().get()) {
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Applying " + log);
            return (T)Utils$.MODULE$.withContextClassLoader(this.classloader(), f);
        }
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Not applying " + log);
        return (T)f.apply();
    }

    public <T> T withResources(Function0<T> f) {
        return this.withClassLoaderIfNeeded((Function0 & Serializable)() -> JobArtifactSet$.MODULE$.withActiveJobArtifactState(this.state(), f));
    }

    private ConcurrentHashMap<String, RefCountedCacheId> hashToCachedIdMap() {
        return this.hashToCachedIdMap;
    }

    public CopyOnWriteArrayList<Path> jarsList() {
        return this.jarsList;
    }

    public CopyOnWriteArrayList<String> pythonIncludeList() {
        return this.pythonIncludeList;
    }

    public CopyOnWriteArrayList<Tuple3<Enumeration.Value, Path, Option<String>>> sparkContextRelativePaths() {
        return this.sparkContextRelativePaths;
    }

    public Seq<URL> getAddedJars() {
        return ((IterableOnceOps)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(this.jarsList()).asScala().map((Function1 & Serializable)x$3 -> ArtifactUtils$.MODULE$.concatenatePaths(this.artifactPath(), x$3))).map((Function1 & Serializable)x$4 -> x$4.toUri().toURL())).toSeq();
    }

    public Seq<String> getPythonIncludes() {
        return CollectionConverters$.MODULE$.ListHasAsScala(this.pythonIncludeList()).asScala().toSeq();
    }

    public Option<CacheId> getCachedBlockId(String hash) {
        return Option$.MODULE$.apply((Object)this.hashToCachedIdMap().get(hash)).map((Function1 & Serializable)x$5 -> x$5.id());
    }

    private void transferFile(Path source, Path target, boolean allowOverwrite, boolean deleteSource) {
        Files.createDirectories(target.getParent(), new FileAttribute[0]);
        if (allowOverwrite) {
            ArtifactManager.execute$1(source, target, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CopyOption[]{StandardCopyOption.REPLACE_EXISTING}), deleteSource);
            return;
        }
        ArtifactManager.execute$1(source, target, (Seq)Nil$.MODULE$, deleteSource);
    }

    private boolean transferFile$default$3() {
        return false;
    }

    private boolean transferFile$default$4() {
        return true;
    }

    private Path normalizePath(Path path) {
        String normalizedPathString = ((Object)path).toString().replace('/', File.separatorChar).replace('\\', File.separatorChar);
        return Paths.get(normalizedPathString, new String[0]).normalize();
    }

    public void addArtifact(Path remoteRelativePath, Path serverLocalStagingPath, Option<String> fragment, boolean deleteStagedFile) {
        Object object = new Object();
        try {
            JobArtifactSet$.MODULE$.withActiveJobArtifactState(this.state(), (Function0 & Serializable)() -> {
                Predef$.MODULE$.require(!remoteRelativePath.isAbsolute());
                Path normalizedRemoteRelativePath = this.normalizePath(remoteRelativePath);
                if (normalizedRemoteRelativePath.startsWith("cache" + File.separator)) {
                    File tmpFile = serverLocalStagingPath.toFile();
                    JFunction0.mcV.sp & Serializable x$12 = (JFunction0.mcV.sp & Serializable)() -> {
                        BlockManager blockManager = $this.session.sparkContext().env().blockManager();
                        CacheId blockId = new CacheId($this.session.sessionUUID(), StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(((Object)normalizedRemoteRelativePath).toString()), "cache" + File.separator));
                        BlockManager.TempFileBasedBlockStoreUpdater updater = new BlockManager.TempFileBasedBlockStoreUpdater(blockManager, (BlockId)blockId, StorageLevel$.MODULE$.MEMORY_AND_DISK_SER(), (ClassTag)Predef$.MODULE$.implicitly((Object)ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE))), tmpFile, tmpFile.length(), false, blockManager.TempFileBasedBlockStoreUpdater().apply$default$7());
                        updater.save();
                        RefCountedCacheId oldBlock = this.hashToCachedIdMap().put(blockId.hash(), new RefCountedCacheId(blockId));
                        if (oldBlock != null) {
                            this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Replacing existing cache artifact with hash ", " "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.BLOCK_ID, blockId)})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"in session ", ". "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.SESSION_ID, $this.session.sessionUUID())}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"This may indicate duplicate artifact addition."}))).log((Seq)Nil$.MODULE$))));
                            oldBlock.release(blockManager);
                            return;
                        }
                    };
                    JFunction0.mcV.sp & Serializable x$2 = (JFunction0.mcV.sp & Serializable)() -> tmpFile.delete();
                    JFunction0.mcV.sp & Serializable x$3 = () -> ArtifactManager.$anonfun$addArtifact$5((Function0)x$12);
                    return Utils$.MODULE$.tryWithSafeFinallyAndFailureCallbacks((Function0)x$12, (Function0)x$3, (Function0)x$2);
                }
                if (normalizedRemoteRelativePath.startsWith("classes" + File.separator)) {
                    Path target = ArtifactUtils$.MODULE$.concatenatePaths(this.classDir(), StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(((Object)normalizedRemoteRelativePath).toString()), "classes" + File.separator));
                    this.transferFile(serverLocalStagingPath, target, true, deleteStagedFile);
                    this.sessionArtifactAdded().set(true);
                    this.cachedClassLoader_$eq((Option<ClassLoader>)None$.MODULE$);
                    return BoxedUnit.UNIT;
                }
                Path target = ArtifactUtils$.MODULE$.concatenatePaths(this.artifactPath(), normalizedRemoteRelativePath);
                if (Files.exists(target, new LinkOption[0])) {
                    if (Utils$.MODULE$.contentEquals(target.toFile(), serverLocalStagingPath.toFile())) {
                        throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
                    }
                    throw new SparkRuntimeException("ARTIFACT_ALREADY_EXISTS", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"normalizedRemoteRelativePath"), (Object)((Object)normalizedRemoteRelativePath).toString())})), SparkRuntimeException$.MODULE$.$lessinit$greater$default$3(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$4(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$5());
                }
                Path x$4 = serverLocalStagingPath;
                Path x$5 = target;
                boolean x$6 = deleteStagedFile;
                boolean x$7 = this.transferFile$default$3();
                this.transferFile(x$4, x$5, x$7, x$6);
                String uri = this.artifactURI() + "/" + Utils$.MODULE$.encodeRelativeUnixPathToURIRawPath(FilenameUtils.separatorsToUnix((String)((Object)normalizedRemoteRelativePath).toString()));
                if (normalizedRemoteRelativePath.startsWith("jars" + File.separator)) {
                    $this.session.sparkContext().addJar(uri);
                    this.sparkContextRelativePaths().add((Tuple3<Enumeration.Value, Path, Option<String>>)new Tuple3((Object)ArtifactManager$SparkContextResourceType$.MODULE$.JAR(), (Object)normalizedRemoteRelativePath, (Object)fragment));
                    this.jarsList().add(normalizedRemoteRelativePath);
                    this.sessionArtifactAdded().set(true);
                    this.cachedClassLoader_$eq((Option<ClassLoader>)None$.MODULE$);
                    return BoxedUnit.UNIT;
                }
                if (normalizedRemoteRelativePath.startsWith("pyfiles" + File.separator)) {
                    $this.session.sparkContext().addFile(uri);
                    this.sparkContextRelativePaths().add((Tuple3<Enumeration.Value, Path, Option<String>>)new Tuple3((Object)ArtifactManager$SparkContextResourceType$.MODULE$.FILE(), (Object)normalizedRemoteRelativePath, (Object)fragment));
                    String stringRemotePath = ((Object)normalizedRemoteRelativePath).toString();
                    if (stringRemotePath.endsWith(".zip") || stringRemotePath.endsWith(".egg") || stringRemotePath.endsWith(".jar")) {
                        return BoxesRunTime.boxToBoolean((boolean)this.pythonIncludeList().add(((Object)target.getFileName()).toString()));
                    }
                    return BoxedUnit.UNIT;
                }
                if (normalizedRemoteRelativePath.startsWith("archives" + File.separator)) {
                    UriBuilder uriBuilder = Utils$.MODULE$.getUriBuilder(new URI(uri));
                    Object canonicalUri = fragment.map((Function1 & Serializable)x$1 -> uriBuilder.fragment(x$1)).getOrElse((Function0 & Serializable)() -> new URI(uri));
                    $this.session.sparkContext().addArchive(canonicalUri.toString());
                    return BoxesRunTime.boxToBoolean((boolean)this.sparkContextRelativePaths().add((Tuple3<Enumeration.Value, Path, Option<String>>)new Tuple3((Object)ArtifactManager$SparkContextResourceType$.MODULE$.ARCHIVE(), (Object)normalizedRemoteRelativePath, (Object)fragment)));
                }
                if (normalizedRemoteRelativePath.startsWith("files" + File.separator)) {
                    $this.session.sparkContext().addFile(uri);
                    return BoxesRunTime.boxToBoolean((boolean)this.sparkContextRelativePaths().add((Tuple3<Enumeration.Value, Path, Option<String>>)new Tuple3((Object)ArtifactManager$SparkContextResourceType$.MODULE$.FILE(), (Object)normalizedRemoteRelativePath, (Object)fragment)));
                }
                return BoxedUnit.UNIT;
            });
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
            }
            throw ex;
        }
    }

    public boolean addArtifact$default$4() {
        return true;
    }

    public void addLocalArtifacts(Seq<Artifact> artifacts) {
        ListBuffer failedArtifactExceptions = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        artifacts.foreach((Function1 & Serializable)artifact -> {
            BoxedUnit boxedUnit;
            try {
                Artifact.LocalData localData = artifact.storage();
                if (localData instanceof Artifact.LocalFile) {
                    Artifact.LocalFile localFile = (Artifact.LocalFile)localData;
                    this.addArtifact(artifact.path(), localFile.path(), (Option<String>)None$.MODULE$, false);
                } else if (localData instanceof Artifact.InMemory) {
                    Artifact.InMemory inMemory = (Artifact.InMemory)localData;
                    Path tempDir = Utils$.MODULE$.createTempDir().toPath();
                    Path tempFile = tempDir.resolve(artifact.path().getFileName());
                    OutputStream outStream = Files.newOutputStream(tempFile, new OpenOption[0]);
                    JFunction0.mcV.sp & Serializable x$1 = (JFunction0.mcV.sp & Serializable)() -> {
                        inMemory.stream().transferTo(outStream);
                        this.addArtifact(artifact.path(), tempFile, (Option<String>)None$.MODULE$, this.addArtifact$default$4());
                    };
                    JFunction0.mcV.sp & Serializable x$2 = (JFunction0.mcV.sp & Serializable)() -> outStream.close();
                    JFunction0.mcV.sp & Serializable x$3 = () -> ArtifactManager.$anonfun$addLocalArtifacts$4((Function0)x$1);
                    BoxedUnit cfr_ignored_0 = (BoxedUnit)Utils$.MODULE$.tryWithSafeFinallyAndFailureCallbacks((Function0)x$1, (Function0)x$3, (Function0)x$2);
                } else {
                    throw SparkException$.MODULE$.internalError("Unsupported artifact storage: " + artifact.storage());
                }
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable2 instanceof SparkRuntimeException) {
                    SparkRuntimeException sparkRuntimeException = (SparkRuntimeException)throwable2;
                    String string = sparkRuntimeException.getCondition();
                    String string2 = "ARTIFACT_ALREADY_EXISTS";
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        boxedUnit = failedArtifactExceptions.$plus$eq((Object)sparkRuntimeException);
                    }
                }
                throw throwable;
            }
            return boxedUnit;
        });
        if (failedArtifactExceptions.nonEmpty()) {
            throw ArtifactUtils$.MODULE$.mergeExceptionsWithSuppressed(failedArtifactExceptions.toSeq());
        }
    }

    public synchronized ClassLoader classloader() {
        return (ClassLoader)this.cachedClassLoader().getOrElse((Function0 & Serializable)() -> {
            ClassLoader loader = this.buildClassLoader();
            this.cachedClassLoader_$eq((Option<ClassLoader>)new Some((Object)loader));
            return loader;
        });
    }

    private ClassLoader buildClassLoader() {
        URL[] urls = (URL[])((IterableOnceOps)this.getAddedJars().$colon$plus((Object)this.classDir().toUri().toURL())).toArray(ClassTag$.MODULE$.apply(URL.class));
        Seq prefixes = (Seq)SparkEnv$.MODULE$.get().conf().get(package$.MODULE$.CONNECT_SCALA_UDF_STUB_PREFIXES());
        boolean userClasspathFirst = BoxesRunTime.unboxToBoolean((Object)SparkEnv$.MODULE$.get().conf().get(package$.MODULE$.EXECUTOR_USER_CLASS_PATH_FIRST()));
        NonClosableMutableURLClassLoader fallbackClassLoader = this.session.sharedState().jarClassLoader();
        Object loader = prefixes.nonEmpty() ? (userClasspathFirst ? new ChildFirstURLClassLoader(urls, (ClassLoader)StubClassLoader$.MODULE$.apply((ClassLoader)((Object)fallbackClassLoader), prefixes)) : new ChildFirstURLClassLoader(urls, (ClassLoader)StubClassLoader$.MODULE$.apply(null, prefixes), (ClassLoader)((Object)fallbackClassLoader))) : (userClasspathFirst ? new ChildFirstURLClassLoader(urls, (ClassLoader)((Object)fallbackClassLoader)) : new URLClassLoader(urls, (ClassLoader)((Object)fallbackClassLoader)));
        this.logDebug((Function0<String>)((Function0 & Serializable)() -> ArtifactManager.$anonfun$buildClassLoader$1((URLClassLoader)loader, urls)));
        return loader;
    }

    public ArtifactManager clone(SparkSession newSession) {
        SparkContext sparkContext = this.session.sparkContext();
        ArtifactManager newArtifactManager = new ArtifactManager(newSession);
        if (this.artifactPath().toFile().exists()) {
            Utils$.MODULE$.copyDirectory(this.artifactPath().toFile(), newArtifactManager.artifactPath().toFile());
        }
        this.hashToCachedIdMap().forEach((hash, refCountedCacheId) -> {
            try {
                refCountedCacheId.acquire();
                newArtifactManager.hashToCachedIdMap().put((String)hash, (RefCountedCacheId)refCountedCacheId);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable2 instanceof SparkRuntimeException) {
                    SparkRuntimeException sparkRuntimeException = (SparkRuntimeException)throwable2;
                    String string = sparkRuntimeException.getCondition();
                    String string2 = "BLOCK_ALREADY_RELEASED";
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        throw new SparkRuntimeException("INTERNAL_ERROR", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message"), (Object)("Cannot clone ArtifactManager: cached block with hash " + hash + " was already released. The parent session may have been closed during cloning."))})), (Throwable)sparkRuntimeException, SparkRuntimeException$.MODULE$.$lessinit$greater$default$4(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$5());
                    }
                }
                throw throwable;
            }
        });
        JobArtifactSet$.MODULE$.withActiveJobArtifactState(newArtifactManager.state(), (Function0)(JFunction0.mcV.sp & Serializable)() -> this.sparkContextRelativePaths().forEach((Consumer<Tuple3<Enumeration.Value, Path, Option<String>>>)((Consumer<Tuple3>)x0$1 -> {
            Tuple3 tuple3 = x0$1;
            if (tuple3 != null) {
                Enumeration.Value resourceType = (Enumeration.Value)tuple3._1();
                Path relativePath = (Path)tuple3._2();
                Option fragment = (Option)tuple3._3();
                String uri = newArtifactManager.artifactURI() + "/" + Utils$.MODULE$.encodeRelativeUnixPathToURIRawPath(FilenameUtils.separatorsToUnix((String)((Object)relativePath).toString()));
                Enumeration.Value value = resourceType;
                Enumeration.Value value2 = ArtifactManager$SparkContextResourceType$.MODULE$.JAR();
                Enumeration.Value value3 = value;
                if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                    sparkContext.addJar(uri);
                } else {
                    Enumeration.Value value4 = ArtifactManager$SparkContextResourceType$.MODULE$.FILE();
                    Enumeration.Value value5 = value;
                    if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                        sparkContext.addFile(uri);
                    } else {
                        Enumeration.Value value6 = ArtifactManager$SparkContextResourceType$.MODULE$.ARCHIVE();
                        Enumeration.Value value7 = value;
                        if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                            UriBuilder uriBuilder = Utils$.MODULE$.getUriBuilder(new URI(uri));
                            Object canonicalUri = fragment.map((Function1 & Serializable)x$1 -> uriBuilder.fragment(x$1)).getOrElse((Function0 & Serializable)() -> new URI(uri));
                            sparkContext.addArchive(canonicalUri.toString());
                        } else {
                            throw SparkException$.MODULE$.internalError("Unsupported resource type: " + resourceType);
                        }
                    }
                }
                return;
            }
            throw new MatchError((Object)tuple3);
        })));
        newArtifactManager.jarsList().addAll(this.jarsList());
        newArtifactManager.pythonIncludeList().addAll(this.pythonIncludeList());
        newArtifactManager.sparkContextRelativePaths().addAll(this.sparkContextRelativePaths());
        return newArtifactManager;
    }

    private ArtifactStateForCleanup cleanUpStateForGlobalResources() {
        return this.cleanUpStateForGlobalResources;
    }

    private Cleaner.Cleanable getCleanable() {
        return ArtifactManager$.MODULE$.org$apache$spark$sql$artifact$ArtifactManager$$cleaner().register(this, new StateCleanupRunner(this.cleanUpStateForGlobalResources()));
    }

    private Cleaner.Cleanable cleanable() {
        return this.cleanable;
    }

    private void cleanable_$eq(Cleaner.Cleanable x$1) {
        this.cleanable = x$1;
    }

    private void cleanUpResources() {
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Cleaning up resources for session with sessionUUID " + $this.session.sessionUUID());
        this.cleanable().clean();
        BlockManager blockManager = this.session.sparkContext().env().blockManager();
        this.hashToCachedIdMap().values().forEach(refCountedCacheId -> refCountedCacheId.release(blockManager));
        this.hashToCachedIdMap().clear();
        this.jarsList().clear();
        this.pythonIncludeList().clear();
        this.sparkContextRelativePaths().clear();
        this.cachedClassLoader().foreach((Function1 & Serializable)x0$1 -> {
            ArtifactManager.$anonfun$cleanUpResources$3(this, x0$1);
            return BoxedUnit.UNIT;
        });
        this.cachedClassLoader_$eq((Option<ClassLoader>)None$.MODULE$);
    }

    @Override
    public void close() {
        this.cleanUpResources();
    }

    public void cleanUpResourcesForTesting() {
        this.cleanUpResources();
        this.cleanable_$eq(this.getCleanable());
    }

    public void uploadArtifactToFs(Path remoteRelativePath, Path serverLocalStagingPath) {
        boolean allowDestLocalConf;
        Path normalizedRemoteRelativePath = this.normalizePath(remoteRelativePath);
        Configuration hadoopConf = this.session.sparkContext().hadoopConfiguration();
        Predef$.MODULE$.assert(normalizedRemoteRelativePath.startsWith(ArtifactManager$.MODULE$.forwardToFSPrefix() + File.separator));
        org.apache.hadoop.fs.Path destFSPath = new org.apache.hadoop.fs.Path(((Object)Paths.get(File.separator, new String[0]).resolve(normalizedRemoteRelativePath.subpath(1, normalizedRemoteRelativePath.getNameCount()))).toString());
        Path localPath = serverLocalStagingPath;
        FileSystem fs = destFSPath.getFileSystem(hadoopConf);
        if (fs instanceof LocalFileSystem && !(allowDestLocalConf = BoxesRunTime.unboxToBoolean((Object)this.session.sessionState().conf().getConf(SQLConf$.MODULE$.ARTIFACT_COPY_FROM_LOCAL_TO_FS_ALLOW_DEST_LOCAL()).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> $this.session.conf().get("spark.connect.copyFromLocalToFs.allowDestLocal").contains("true"))))) {
            throw new SparkUnsupportedOperationException("_LEGACY_ERROR_TEMP_3161");
        }
        fs.copyFromLocalFile(false, true, new org.apache.hadoop.fs.Path(((Object)localPath).toString()), destFSPath);
    }

    private static final Path execute$1(Path s, Path t, Seq opt, boolean deleteSource$1) {
        if (deleteSource$1) {
            return Files.move(s, t, (CopyOption[])opt.toArray(ClassTag$.MODULE$.apply(CopyOption.class)));
        }
        return Files.copy(s, t, (CopyOption[])opt.toArray(ClassTag$.MODULE$.apply(CopyOption.class)));
    }

    public static final /* synthetic */ void $anonfun$addArtifact$5(Function0 x$1$1) {
        Utils$.MODULE$.tryWithSafeFinallyAndFailureCallbacks$default$2(x$1$1);
    }

    public static final /* synthetic */ void $anonfun$addLocalArtifacts$4(Function0 x$1$2) {
        Utils$.MODULE$.tryWithSafeFinallyAndFailureCallbacks$default$2(x$1$2);
    }

    public static final /* synthetic */ String $anonfun$buildClassLoader$1(URLClassLoader loader$1, URL[] urls$1) {
        return "Using class loader: " + loader$1 + ", containing urls: " + urls$1;
    }

    public static final /* synthetic */ void $anonfun$cleanUpResources$3(ArtifactManager $this, ClassLoader x0$1) {
        ClassLoader classLoader = x0$1;
        if (classLoader instanceof URLClassLoader) {
            BoxedUnit boxedUnit;
            URLClassLoader uRLClassLoader = (URLClassLoader)classLoader;
            try {
                uRLClassLoader.close();
                $this.logDebug(LogEntry$.MODULE$.from((Function0 & Serializable)() -> $this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Closed URLClassLoader for session "}))).log((Seq)Nil$.MODULE$).$plus($this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{$this.MDC((LogKey)LogKeys.SESSION_ID, $this.session.sessionUUID())})))));
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (IOException e) {
                $this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> $this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to close URLClassLoader for session "}))).log((Seq)Nil$.MODULE$).$plus($this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{$this.MDC((LogKey)LogKeys.SESSION_ID, $this.session.sessionUUID())})))), (Throwable)e);
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    public ArtifactManager(SparkSession session) {
        this.session = session;
        Logging.$init$((Logging)this);
        Tuple2 tuple2 = new Tuple2((Object)ArtifactUtils$.MODULE$.concatenatePaths(this.artifactRootPath(), session.sessionUUID()), (Object)(this.artifactRootURI() + "/" + session.sessionUUID()));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Path artifactPath = (Path)tuple2._1();
        String artifactURI = (String)tuple2._2();
        this.x$1 = new Tuple2((Object)artifactPath, (Object)artifactURI);
        this.artifactPath = (Path)this.x$1._1();
        this.artifactURI = (String)this.x$1._2();
        Tuple2 tuple22 = new Tuple2((Object)ArtifactUtils$.MODULE$.concatenatePaths(this.artifactPath(), "classes"), (Object)(this.artifactURI() + "/classes/"));
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        Path classDir = (Path)tuple22._1();
        String replClassURI = (String)tuple22._2();
        this.x$2 = new Tuple2((Object)classDir, (Object)replClassURI);
        this.classDir = (Path)this.x$2._1();
        this.replClassURI = (String)this.x$2._2();
        this.sessionArtifactAdded = new AtomicBoolean(false);
        this.cachedClassLoader = None$.MODULE$;
        this.hashToCachedIdMap = new ConcurrentHashMap();
        this.jarsList = new CopyOnWriteArrayList();
        this.pythonIncludeList = new CopyOnWriteArrayList();
        this.sparkContextRelativePaths = new CopyOnWriteArrayList();
        this.cleanUpStateForGlobalResources = new ArtifactStateForCleanup(session.sessionUUID(), session.sparkContext(), this.state(), this.artifactPath());
        this.cleanable = this.getCleanable();
    }

    private static class StateCleanupRunner
    implements Runnable {
        private final ArtifactStateForCleanup cleanupState;

        @Override
        public void run() {
            ArtifactManager$.MODULE$.org$apache$spark$sql$artifact$ArtifactManager$$cleanUpGlobalResources(this.cleanupState);
        }

        public StateCleanupRunner(ArtifactStateForCleanup cleanupState) {
            this.cleanupState = cleanupState;
        }
    }
}

