/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.error;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apache.commons.text.StringEscapeUtils;
import org.apereo.cas.pac4j.client.DelegatedClientAuthenticationFailureEvaluator;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.web.flow.DelegatedClientAuthenticationConfigurationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.servlet.ModelAndView;

public class DefaultDelegatedClientAuthenticationFailureEvaluator
implements DelegatedClientAuthenticationFailureEvaluator {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultDelegatedClientAuthenticationFailureEvaluator.class);
    protected final DelegatedClientAuthenticationConfigurationContext configContext;

    public Optional<ModelAndView> evaluate(HttpServletRequest request, int status) {
        Map params = request.getParameterMap();
        boolean foundError = Stream.of("error", "error_code", "error_description", "error_message").anyMatch(params::containsKey) || HttpStatus.resolve((int)status).isError();
        return (Optional)FunctionUtils.doIf((boolean)foundError, () -> {
            HashMap<String, Object> model = new HashMap<String, Object>();
            if (params.containsKey("error_code")) {
                model.put("code", StringEscapeUtils.escapeHtml4((String)request.getParameter("error_code")));
            } else {
                model.put("code", status);
            }
            model.put("error", StringEscapeUtils.escapeHtml4((String)request.getParameter("error")));
            model.put("reason", StringEscapeUtils.escapeHtml4((String)request.getParameter("error_reason")));
            if (params.containsKey("error_description")) {
                model.put("description", StringEscapeUtils.escapeHtml4((String)request.getParameter("error_description")));
            } else if (params.containsKey("error_message")) {
                model.put("description", StringEscapeUtils.escapeHtml4((String)request.getParameter("error_message")));
            }
            model.put("service", request.getAttribute("service"));
            this.configContext.getDelegatedClientNameExtractor().extract(request).map(StringEscapeUtils::escapeHtml4).ifPresent(name -> model.put("client", name));
            model.entrySet().removeIf(e -> e.getValue() == null);
            LOGGER.debug("Delegation request has failed. Details are [{}]", model);
            return Optional.of(new ModelAndView("delegated-authn/casDelegatedAuthnStopWebflow", model));
        }, Optional::empty).get();
    }

    @Generated
    public DefaultDelegatedClientAuthenticationFailureEvaluator(DelegatedClientAuthenticationConfigurationContext configContext) {
        this.configContext = configContext;
    }
}

