/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.statement.merge;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import liquibase.repackaged.net.sf.jsqlparser.expression.Expression;
import liquibase.repackaged.net.sf.jsqlparser.schema.Column;

public class MergeUpdate {
    private List<Column> columns = null;
    private List<Expression> values = null;
    private Expression whereCondition;
    private Expression deleteWhereCondition;

    public List<Column> getColumns() {
        return this.columns;
    }

    public void setColumns(List<Column> list) {
        this.columns = list;
    }

    public List<Expression> getValues() {
        return this.values;
    }

    public void setValues(List<Expression> list) {
        this.values = list;
    }

    public Expression getWhereCondition() {
        return this.whereCondition;
    }

    public void setWhereCondition(Expression expression) {
        this.whereCondition = expression;
    }

    public Expression getDeleteWhereCondition() {
        return this.deleteWhereCondition;
    }

    public void setDeleteWhereCondition(Expression expression) {
        this.deleteWhereCondition = expression;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" WHEN MATCHED THEN UPDATE SET ");
        for (int i2 = 0; i2 < this.columns.size(); ++i2) {
            if (i2 != 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.columns.get(i2).toString()).append(" = ").append(this.values.get(i2).toString());
        }
        if (this.whereCondition != null) {
            stringBuilder.append(" WHERE ").append(this.whereCondition.toString());
        }
        if (this.deleteWhereCondition != null) {
            stringBuilder.append(" DELETE WHERE ").append(this.deleteWhereCondition.toString());
        }
        return stringBuilder.toString();
    }

    public MergeUpdate withColumns(List<Column> list) {
        this.setColumns(list);
        return this;
    }

    public MergeUpdate withValues(List<Expression> list) {
        this.setValues(list);
        return this;
    }

    public MergeUpdate withWhereCondition(Expression expression) {
        this.setWhereCondition(expression);
        return this;
    }

    public MergeUpdate withDeleteWhereCondition(Expression expression) {
        this.setDeleteWhereCondition(expression);
        return this;
    }

    public MergeUpdate addColumns(Column ... columnArray) {
        List list = Optional.ofNullable(this.getColumns()).orElseGet(ArrayList::new);
        Collections.addAll(list, columnArray);
        return this.withColumns(list);
    }

    public MergeUpdate addColumns(Collection<? extends Column> collection) {
        List list = Optional.ofNullable(this.getColumns()).orElseGet(ArrayList::new);
        list.addAll(collection);
        return this.withColumns(list);
    }

    public MergeUpdate addValues(Expression ... expressionArray) {
        List list = Optional.ofNullable(this.getValues()).orElseGet(ArrayList::new);
        Collections.addAll(list, expressionArray);
        return this.withValues(list);
    }

    public MergeUpdate addValues(Collection<? extends Expression> collection) {
        List list = Optional.ofNullable(this.getValues()).orElseGet(ArrayList::new);
        list.addAll(collection);
        return this.withValues(list);
    }

    public <E extends Expression> E getWhereCondition(Class<E> clazz) {
        return (E)((Expression)clazz.cast(this.getWhereCondition()));
    }

    public <E extends Expression> E getDeleteWhereCondition(Class<E> clazz) {
        return (E)((Expression)clazz.cast(this.getDeleteWhereCondition()));
    }
}

