/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.local;

import io.github.bucket4j.Bandwidth;
import io.github.bucket4j.BucketConfiguration;
import io.github.bucket4j.BucketExceptions;
import io.github.bucket4j.ConfigurationBuilder;
import io.github.bucket4j.Experimental;
import io.github.bucket4j.MathType;
import io.github.bucket4j.TimeMeter;
import io.github.bucket4j.local.LocalBucket;
import io.github.bucket4j.local.LockFreeBucket;
import io.github.bucket4j.local.SynchronizationStrategy;
import io.github.bucket4j.local.SynchronizedBucket;
import io.github.bucket4j.local.ThreadUnsafeBucket;
import java.util.Objects;

public class LocalBucketBuilder {
    private final ConfigurationBuilder configurationBuilder;
    private TimeMeter timeMeter = TimeMeter.SYSTEM_MILLISECONDS;
    private SynchronizationStrategy synchronizationStrategy = SynchronizationStrategy.LOCK_FREE;
    private MathType mathType = MathType.INTEGER_64_BITS;

    public LocalBucketBuilder() {
        this.configurationBuilder = new ConfigurationBuilder();
    }

    public LocalBucketBuilder addLimit(Bandwidth bandwidth) {
        this.configurationBuilder.addLimit(bandwidth);
        return this;
    }

    public LocalBucketBuilder withNanosecondPrecision() {
        this.timeMeter = TimeMeter.SYSTEM_NANOTIME;
        return this;
    }

    public LocalBucketBuilder withMillisecondPrecision() {
        this.timeMeter = TimeMeter.SYSTEM_MILLISECONDS;
        return this;
    }

    public LocalBucketBuilder withCustomTimePrecision(TimeMeter customTimeMeter) {
        if (customTimeMeter == null) {
            throw BucketExceptions.nullTimeMeter();
        }
        this.timeMeter = customTimeMeter;
        return this;
    }

    public LocalBucketBuilder withSynchronizationStrategy(SynchronizationStrategy synchronizationStrategy) {
        if (synchronizationStrategy == null) {
            throw BucketExceptions.nullSynchronizationStrategy();
        }
        this.synchronizationStrategy = synchronizationStrategy;
        return this;
    }

    @Experimental
    public LocalBucketBuilder withMath(MathType mathType) {
        this.mathType = Objects.requireNonNull(mathType);
        return this;
    }

    public LocalBucket build() {
        BucketConfiguration configuration = this.buildConfiguration();
        switch (this.synchronizationStrategy) {
            case LOCK_FREE: {
                return new LockFreeBucket(configuration, this.mathType, this.timeMeter);
            }
            case SYNCHRONIZED: {
                return new SynchronizedBucket(configuration, this.mathType, this.timeMeter);
            }
            case NONE: {
                return new ThreadUnsafeBucket(configuration, this.mathType, this.timeMeter);
            }
        }
        throw new IllegalStateException();
    }

    private BucketConfiguration buildConfiguration() {
        BucketConfiguration configuration = this.configurationBuilder.build();
        for (Bandwidth bandwidth : configuration.getBandwidths()) {
            if (!bandwidth.isIntervallyAligned() || this.timeMeter.isWallClockBased()) continue;
            throw BucketExceptions.intervallyAlignedRefillCompatibleOnlyWithWallClock();
        }
        return configuration;
    }
}

