/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.bpmn.data;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.util.StdDateFormat;
import java.text.DateFormat;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.impl.bpmn.data.AbstractDataAssociation;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.variable.api.types.VariableTypes;

public class TransformationDataOutputAssociation
extends AbstractDataAssociation {
    private static final long serialVersionUID = 1L;
    protected Expression transformation;

    public TransformationDataOutputAssociation(String sourceRef, String targetRef, Expression transformation) {
        super(sourceRef, targetRef);
        this.transformation = transformation;
    }

    @Override
    public void evaluate(DelegateExecution execution) {
        Object value = this.transformation.getValue((VariableContainer)execution);
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration();
        VariableTypes variableTypes = processEngineConfiguration.getVariableServiceConfiguration().getVariableTypes();
        try {
            variableTypes.findVariableType(value);
        }
        catch (FlowableException e) {
            try {
                ObjectMapper mapper = new ObjectMapper();
                mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
                mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
                mapper.setDateFormat((DateFormat)new StdDateFormat().withColonInTimeZone(true));
                value = mapper.convertValue(value, JsonNode.class);
            }
            catch (IllegalArgumentException e1) {
                throw new FlowableException("An error occurs converting output value as JSon", (Throwable)e1);
            }
        }
        execution.setVariable(this.getTarget(), value);
    }
}

