/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.statsd;

import io.micrometer.core.instrument.config.MeterRegistryConfig;
import io.micrometer.core.instrument.config.MeterRegistryConfigValidator;
import io.micrometer.core.instrument.config.validate.PropertyValidator;
import io.micrometer.core.instrument.config.validate.Validated;
import io.micrometer.statsd.StatsdFlavor;
import io.micrometer.statsd.StatsdProtocol;
import java.time.Duration;
import java.util.function.Function;

public interface StatsdConfig
extends MeterRegistryConfig {
    public static final StatsdConfig DEFAULT = k -> null;

    default public String prefix() {
        return "statsd";
    }

    default public StatsdFlavor flavor() {
        return (StatsdFlavor)((Object)PropertyValidator.getEnum((MeterRegistryConfig)this, StatsdFlavor.class, (String)"flavor").orElse((Object)StatsdFlavor.DATADOG));
    }

    default public boolean enabled() {
        return (Boolean)PropertyValidator.getBoolean((MeterRegistryConfig)this, (String)"enabled").orElse((Object)true);
    }

    default public String host() {
        return (String)PropertyValidator.getString((MeterRegistryConfig)this, (String)"host").orElse((Object)"localhost");
    }

    default public int port() {
        return (Integer)PropertyValidator.getInteger((MeterRegistryConfig)this, (String)"port").orElse((Object)8125);
    }

    default public StatsdProtocol protocol() {
        return (StatsdProtocol)((Object)PropertyValidator.getEnum((MeterRegistryConfig)this, StatsdProtocol.class, (String)"protocol").orElse((Object)StatsdProtocol.UDP));
    }

    default public int maxPacketLength() {
        return (Integer)PropertyValidator.getInteger((MeterRegistryConfig)this, (String)"maxPacketLength").orElse((Object)1400);
    }

    default public Duration pollingFrequency() {
        return (Duration)PropertyValidator.getDuration((MeterRegistryConfig)this, (String)"pollingFrequency").orElse((Object)Duration.ofSeconds(10L));
    }

    @Deprecated
    default public int queueSize() {
        return (Integer)PropertyValidator.getInteger((MeterRegistryConfig)this, (String)"queueSize").orElse((Object)Integer.MAX_VALUE);
    }

    default public Duration step() {
        return (Duration)PropertyValidator.getDuration((MeterRegistryConfig)this, (String)"step").orElse((Object)Duration.ofMinutes(1L));
    }

    default public boolean publishUnchangedMeters() {
        return (Boolean)PropertyValidator.getBoolean((MeterRegistryConfig)this, (String)"publishUnchangedMeters").orElse((Object)true);
    }

    default public boolean buffered() {
        return (Boolean)PropertyValidator.getBoolean((MeterRegistryConfig)this, (String)"buffered").orElse((Object)true);
    }

    default public Validated<?> validate() {
        return MeterRegistryConfigValidator.checkAll((MeterRegistryConfig)this, (Function[])new Function[]{MeterRegistryConfigValidator.checkRequired((String)"flavor", StatsdConfig::flavor), MeterRegistryConfigValidator.checkRequired((String)"host", StatsdConfig::host), MeterRegistryConfigValidator.check((String)"port", StatsdConfig::port), MeterRegistryConfigValidator.checkRequired((String)"protocol", StatsdConfig::protocol), MeterRegistryConfigValidator.checkRequired((String)"pollingFrequency", StatsdConfig::pollingFrequency), MeterRegistryConfigValidator.checkRequired((String)"step", StatsdConfig::step)});
    }
}

