/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.authorization.method;

import jakarta.annotation.security.DenyAll;
import jakarta.annotation.security.PermitAll;
import jakarta.annotation.security.RolesAllowed;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.lang.NonNull;
import org.springframework.security.authorization.AuthoritiesAuthorizationManager;
import org.springframework.security.authorization.AuthorizationDecision;
import org.springframework.security.authorization.AuthorizationManager;
import org.springframework.security.authorization.AuthorizationResult;
import org.springframework.security.authorization.method.AbstractAuthorizationManagerRegistry;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.annotation.SecurityAnnotationScanner;
import org.springframework.security.core.annotation.SecurityAnnotationScanners;
import org.springframework.util.Assert;

public final class Jsr250AuthorizationManager
implements AuthorizationManager<MethodInvocation> {
    private final Jsr250AuthorizationManagerRegistry registry = new Jsr250AuthorizationManagerRegistry();
    private AuthorizationManager<Collection<String>> authoritiesAuthorizationManager = new AuthoritiesAuthorizationManager();
    private String rolePrefix = "ROLE_";

    public void setAuthoritiesAuthorizationManager(AuthorizationManager<Collection<String>> authoritiesAuthorizationManager) {
        Assert.notNull(authoritiesAuthorizationManager, (String)"authoritiesAuthorizationManager cannot be null");
        this.authoritiesAuthorizationManager = authoritiesAuthorizationManager;
    }

    public void setRolePrefix(String rolePrefix) {
        Assert.notNull((Object)rolePrefix, (String)"rolePrefix cannot be null");
        this.rolePrefix = rolePrefix;
    }

    @Override
    @Deprecated
    public AuthorizationDecision check(Supplier<Authentication> authentication, MethodInvocation methodInvocation) {
        AuthorizationManager<MethodInvocation> delegate = this.registry.getManager(methodInvocation);
        return delegate.check(authentication, methodInvocation);
    }

    private final class Jsr250AuthorizationManagerRegistry
    extends AbstractAuthorizationManagerRegistry {
        private final SecurityAnnotationScanner<?> scanner = SecurityAnnotationScanners.requireUnique(List.of(DenyAll.class, PermitAll.class, RolesAllowed.class));

        private Jsr250AuthorizationManagerRegistry() {
        }

        @Override
        @NonNull
        AuthorizationManager<MethodInvocation> resolveManager(Method method, Class<?> targetClass) {
            Annotation annotation = this.findJsr250Annotation(method, targetClass);
            if (annotation instanceof DenyAll) {
                return (a, o) -> new AuthorizationDecision(false);
            }
            if (annotation instanceof PermitAll) {
                return (a, o) -> new AuthorizationDecision(true);
            }
            if (annotation instanceof RolesAllowed) {
                RolesAllowed rolesAllowed = (RolesAllowed)annotation;
                return (a, o) -> Jsr250AuthorizationManager.this.authoritiesAuthorizationManager.authorize(a, this.getAllowedRolesWithPrefix(rolesAllowed));
            }
            return NULL_MANAGER;
        }

        private Annotation findJsr250Annotation(Method method, Class<?> targetClass) {
            Class<?> targetClassToUse = targetClass != null ? targetClass : method.getDeclaringClass();
            return this.scanner.scan(method, targetClassToUse);
        }

        private Set<String> getAllowedRolesWithPrefix(RolesAllowed rolesAllowed) {
            HashSet<String> roles = new HashSet<String>();
            for (int i = 0; i < rolesAllowed.value().length; ++i) {
                roles.add(Jsr250AuthorizationManager.this.rolePrefix + rolesAllowed.value()[i]);
            }
            return roles;
        }
    }

    private static interface AuthorizationManagerCheckAdapter<T>
    extends AuthorizationManager<T> {
        @Override
        default public AuthorizationDecision check(Supplier<Authentication> authentication, T object) {
            AuthorizationResult result = this.authorize(authentication, object);
            if (result == null) {
                return null;
            }
            if (result instanceof AuthorizationDecision) {
                AuthorizationDecision decision = (AuthorizationDecision)result;
                return decision;
            }
            throw new IllegalArgumentException("please call #authorize or ensure that the result is of type AuthorizationDecision");
        }

        @Override
        public AuthorizationResult authorize(Supplier<Authentication> var1, T var2);
    }
}

