/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.ext.openfga.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.StringJoiner;
import org.apache.syncope.ext.openfga.client.ApiClient;
import org.apache.syncope.ext.openfga.client.model.BatchCheckItem;
import org.apache.syncope.ext.openfga.client.model.ConsistencyPreference;

@JsonPropertyOrder(value={"checks", "authorization_model_id", "consistency"})
public class BatchCheckRequest {
    public static final String JSON_PROPERTY_CHECKS = "checks";
    @Nonnull
    private List<BatchCheckItem> checks = new ArrayList<BatchCheckItem>();
    public static final String JSON_PROPERTY_AUTHORIZATION_MODEL_ID = "authorization_model_id";
    @Nullable
    private String authorizationModelId;
    public static final String JSON_PROPERTY_CONSISTENCY = "consistency";
    @Nullable
    private ConsistencyPreference consistency = ConsistencyPreference.UNSPECIFIED;

    public BatchCheckRequest checks(@Nonnull List<BatchCheckItem> checks) {
        this.checks = checks;
        return this;
    }

    public BatchCheckRequest addChecksItem(BatchCheckItem checksItem) {
        if (this.checks == null) {
            this.checks = new ArrayList<BatchCheckItem>();
        }
        this.checks.add(checksItem);
        return this;
    }

    @Nonnull
    @JsonProperty(value="checks", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<BatchCheckItem> getChecks() {
        return this.checks;
    }

    @JsonProperty(value="checks", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setChecks(@Nonnull List<BatchCheckItem> checks) {
        this.checks = checks;
    }

    public BatchCheckRequest authorizationModelId(@Nullable String authorizationModelId) {
        this.authorizationModelId = authorizationModelId;
        return this;
    }

    @Nullable
    @JsonProperty(value="authorization_model_id", required=false)
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAuthorizationModelId() {
        return this.authorizationModelId;
    }

    @JsonProperty(value="authorization_model_id", required=false)
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAuthorizationModelId(@Nullable String authorizationModelId) {
        this.authorizationModelId = authorizationModelId;
    }

    public BatchCheckRequest consistency(@Nullable ConsistencyPreference consistency) {
        this.consistency = consistency;
        return this;
    }

    @Nullable
    @JsonProperty(value="consistency", required=false)
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ConsistencyPreference getConsistency() {
        return this.consistency;
    }

    @JsonProperty(value="consistency", required=false)
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setConsistency(@Nullable ConsistencyPreference consistency) {
        this.consistency = consistency;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BatchCheckRequest batchCheckRequest = (BatchCheckRequest)o;
        return Objects.equals(this.checks, batchCheckRequest.checks) && Objects.equals(this.authorizationModelId, batchCheckRequest.authorizationModelId) && Objects.equals((Object)this.consistency, (Object)batchCheckRequest.consistency);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.checks, this.authorizationModelId, this.consistency});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BatchCheckRequest {\n");
        sb.append("    checks: ").append(this.toIndentedString(this.checks)).append("\n");
        sb.append("    authorizationModelId: ").append(this.toIndentedString(this.authorizationModelId)).append("\n");
        sb.append("    consistency: ").append(this.toIndentedString((Object)this.consistency)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getChecks() != null) {
            for (int i = 0; i < this.getChecks().size(); ++i) {
                if (this.getChecks().get(i) == null) continue;
                joiner.add(this.getChecks().get(i).toUrlQueryString(String.format(Locale.ROOT, "%schecks%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format(Locale.ROOT, "%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        if (this.getAuthorizationModelId() != null) {
            joiner.add(String.format(Locale.ROOT, "%sauthorization_model_id%s=%s", prefix, suffix, ApiClient.urlEncode(ApiClient.valueToString(this.getAuthorizationModelId()))));
        }
        if (this.getConsistency() != null) {
            joiner.add(String.format(Locale.ROOT, "%sconsistency%s=%s", prefix, suffix, ApiClient.urlEncode(ApiClient.valueToString((Object)this.getConsistency()))));
        }
        return joiner.toString();
    }
}

