/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.engine.impl.scripting;

import java.util.LinkedList;
import java.util.List;
import java.util.StringJoiner;
import org.flowable.common.engine.api.FlowableIllegalStateException;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.scripting.Resolver;
import org.flowable.common.engine.impl.scripting.ScriptTraceEnhancer;

public class ScriptEngineRequest {
    protected final String language;
    protected final String script;
    protected final VariableContainer scopeContainer;
    protected final VariableContainer inputVariableContainer;
    protected final List<Resolver> additionalResolvers;
    protected final boolean storeScriptVariables;
    protected final ScriptTraceEnhancer traceEnhancer;

    public static Builder builder() {
        return new Builder();
    }

    private ScriptEngineRequest(String script, String language, VariableContainer scopeContainer, VariableContainer inputVariableContainer, boolean storeScriptVariables, List<Resolver> additionalResolvers, ScriptTraceEnhancer errorTraceEnhancer) {
        this.script = script;
        this.language = language;
        this.scopeContainer = scopeContainer;
        this.inputVariableContainer = inputVariableContainer;
        this.storeScriptVariables = storeScriptVariables;
        this.additionalResolvers = additionalResolvers;
        this.traceEnhancer = errorTraceEnhancer;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getScript() {
        return this.script;
    }

    public VariableContainer getScopeContainer() {
        return this.scopeContainer;
    }

    public VariableContainer getInputVariableContainer() {
        return this.inputVariableContainer;
    }

    public boolean isStoreScriptVariables() {
        return this.storeScriptVariables;
    }

    public List<Resolver> getAdditionalResolvers() {
        return this.additionalResolvers;
    }

    public ScriptTraceEnhancer getTraceEnhancer() {
        return this.traceEnhancer;
    }

    public String toString() {
        return new StringJoiner(", ", ScriptEngineRequest.class.getSimpleName() + "[", "]").add("language='" + this.language + "'").add("script='" + this.script + "'").add("variableContainer=" + String.valueOf(this.scopeContainer)).add("storeScriptVariables=" + this.storeScriptVariables).toString();
    }

    public static class Builder {
        protected String language;
        protected String script;
        protected VariableContainer scopeContainer;
        protected VariableContainer inputVariableContainer;
        protected List<Resolver> additionalResolvers = new LinkedList<Resolver>();
        protected boolean storeScriptVariables;
        protected ScriptTraceEnhancer traceEnhancer;

        protected Builder() {
        }

        public Builder script(String script) {
            this.script = script;
            return this;
        }

        public Builder language(String language) {
            this.language = language;
            return this;
        }

        public Builder scopeContainer(VariableContainer variableContainer) {
            this.scopeContainer = variableContainer;
            return this;
        }

        public Builder inputVariableContainer(VariableContainer variableContainer) {
            this.inputVariableContainer = variableContainer;
            return this;
        }

        public Builder storeScriptVariables() {
            this.storeScriptVariables = true;
            return this;
        }

        public Builder additionalResolver(Resolver additionalResolver) {
            this.additionalResolvers.add(additionalResolver);
            return this;
        }

        public Builder traceEnhancer(ScriptTraceEnhancer enhancer) {
            this.traceEnhancer = enhancer;
            return this;
        }

        public ScriptEngineRequest build() {
            if (this.script == null || this.script.isEmpty()) {
                throw new FlowableIllegalStateException("A script is required");
            }
            return new ScriptEngineRequest(this.script, this.language, this.scopeContainer, this.inputVariableContainer != null ? this.inputVariableContainer : this.scopeContainer, this.storeScriptVariables, this.additionalResolvers, this.traceEnhancer);
        }
    }
}

