/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.resolver.impl;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.ChainingMultifactorAuthenticationProvider;
import org.apereo.cas.authentication.MultifactorAuthenticationContextValidationResult;
import org.apereo.cas.authentication.MultifactorAuthenticationProvider;
import org.apereo.cas.authentication.bypass.MultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.apereo.cas.web.flow.resolver.impl.CasWebflowEventResolutionConfigurationContext;
import org.apereo.cas.web.flow.resolver.impl.SelectiveMultifactorAuthenticationProviderWebflowEventResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.Event;

public class CompositeProviderSelectionMultifactorWebflowEventResolver
extends SelectiveMultifactorAuthenticationProviderWebflowEventResolver {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CompositeProviderSelectionMultifactorWebflowEventResolver.class);
    protected final CasCookieBuilder cookieBuilder;

    public CompositeProviderSelectionMultifactorWebflowEventResolver(CasWebflowEventResolutionConfigurationContext configurationContext, CasCookieBuilder cookieBuilder) {
        super(configurationContext);
        this.cookieBuilder = cookieBuilder;
    }

    @Override
    protected Optional<Pair<Collection<Event>, Collection<MultifactorAuthenticationProvider>>> filterEventsByMultifactorAuthenticationProvider(Collection<Event> resolveEvents, Authentication authentication, RegisteredService registeredService, HttpServletRequest request, Service service) throws Throwable {
        Collection resolvedProviders;
        boolean composite = resolveEvents.stream().allMatch(event -> event.getId().equalsIgnoreCase("mfa-composite"));
        if (!composite) {
            return super.filterEventsByMultifactorAuthenticationProvider(resolveEvents, authentication, registeredService, request, service);
        }
        Event event2 = resolveEvents.iterator().next();
        ChainingMultifactorAuthenticationProvider chainingProvider = (ChainingMultifactorAuthenticationProvider)event2.getAttributes().get(MultifactorAuthenticationProvider.class.getName());
        String selectedMfaProvider = this.cookieBuilder.retrieveCookieValue(request);
        Optional selectedProviders = chainingProvider.getMultifactorAuthenticationProviders().stream().filter(provider -> StringUtils.isBlank((CharSequence)selectedMfaProvider) || provider.matches(selectedMfaProvider)).map(provider -> this.getConfigurationContext().getAuthenticationContextValidator().validate(authentication, provider.getId(), Optional.ofNullable(registeredService))).filter(MultifactorAuthenticationContextValidationResult::isSuccess).map(result -> {
            MultifactorAuthenticationProvider validatedProvider = (MultifactorAuthenticationProvider)result.getProvider().orElseThrow();
            Collection validatedEvent = CollectionUtils.wrapCollection((Object[])new Event[]{new Event((Object)this, validatedProvider.getId(), event2.getAttributes())});
            Collection validatedProviders = CollectionUtils.wrapCollection((Object[])new MultifactorAuthenticationProvider[]{validatedProvider});
            return Optional.of(Pair.of((Object)validatedEvent, (Object)validatedProviders));
        }).findAny().orElseGet(() -> {
            List activeProviders = chainingProvider.getMultifactorAuthenticationProviders().stream().filter(provider -> StringUtils.isBlank((CharSequence)selectedMfaProvider) || provider.matches(selectedMfaProvider)).filter(provider -> {
                MultifactorAuthenticationProviderBypassEvaluator bypass = provider.getBypassEvaluator();
                return bypass == null || bypass.shouldMultifactorAuthenticationProviderExecute(authentication, registeredService, provider, request, service);
            }).collect(Collectors.toList());
            LOGGER.debug("Finalized set of resolved events are [{}] with providers [{}]", (Object)resolveEvents, activeProviders);
            return activeProviders.isEmpty() ? Optional.empty() : Optional.of(Pair.of((Object)resolveEvents, activeProviders));
        });
        if (selectedProviders.isPresent() && StringUtils.isNotBlank((CharSequence)selectedMfaProvider) && (resolvedProviders = (Collection)((Pair)selectedProviders.get()).getValue()).size() == 1) {
            MultifactorAuthenticationProvider rememberedProvider = resolvedProviders.stream().filter(provider -> provider.matches(selectedMfaProvider)).findFirst().orElseThrow();
            return Optional.of(Pair.of(Set.of(new Event((Object)this, selectedMfaProvider)), (Object)CollectionUtils.wrapArrayList((Object[])new MultifactorAuthenticationProvider[]{rememberedProvider})));
        }
        return selectedProviders;
    }
}

