/*
 * Decompiled with CFR 0.152.
 */
package com.signalfx.shaded.google.common.collect;

import com.signalfx.shaded.google.common.annotations.GwtCompatible;
import com.signalfx.shaded.google.common.base.Preconditions;
import com.signalfx.shaded.google.common.collect.AbstractIterator;
import com.signalfx.shaded.google.common.collect.ElementTypesAreNonnullByDefault;
import com.signalfx.shaded.javax.annotation.CheckForNull;
import java.util.Queue;

@ElementTypesAreNonnullByDefault
@GwtCompatible
final class ConsumingQueueIterator<T>
extends AbstractIterator<T> {
    private final Queue<T> queue;

    ConsumingQueueIterator(Queue<T> queue) {
        this.queue = Preconditions.checkNotNull(queue);
    }

    @Override
    @CheckForNull
    protected T computeNext() {
        if (this.queue.isEmpty()) {
            return this.endOfData();
        }
        return this.queue.remove();
    }
}

