/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Database;
import org.hsqldb.Row;
import org.hsqldb.RowAction;
import org.hsqldb.Session;
import org.hsqldb.Statement;
import org.hsqldb.Table;
import org.hsqldb.TransactionManager;
import org.hsqldb.TransactionManagerCommon;
import org.hsqldb.error.Error;
import org.hsqldb.persist.PersistentStore;

public class TransactionManager2PL
extends TransactionManagerCommon
implements TransactionManager {
    public TransactionManager2PL(Database database) {
        super(database);
        this.lobSession = this.database.sessionManager.getSysLobSession();
        this.txModel = 0;
    }

    @Override
    public long getSystemChangeNumber() {
        return this.systemChangeNumber.get();
    }

    @Override
    public void setSystemChangeNumber(long l) {
        this.systemChangeNumber.set(l);
    }

    @Override
    public boolean isMVRows() {
        return false;
    }

    @Override
    public boolean isMVCC() {
        return false;
    }

    @Override
    public boolean is2PL() {
        return true;
    }

    @Override
    public int getTransactionControl() {
        return 0;
    }

    @Override
    public void setTransactionControl(Session session, int n) {
        super.setTransactionControl(session, n);
    }

    @Override
    public void completeActions(Session session) {
        this.endActionTPL(session);
    }

    @Override
    public boolean prepareCommitActions(Session session) {
        session.actionSCN = this.getNextSystemChangeNumber();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean commitTransaction(Session session) {
        if (session.abortTransaction) {
            return false;
        }
        this.writeLock.lock();
        try {
            int n = session.rowActionList.size();
            session.transactionEndSCN = session.actionSCN = this.getNextSystemChangeNumber();
            this.endTransaction(session);
            for (int i = 0; i < n; ++i) {
                RowAction rowAction = session.rowActionList.get(i);
                rowAction.commit(session);
            }
            this.adjustLobUsage(session);
            this.persistCommit(session);
            session.isTransaction = false;
            this.endTransactionTPL(session);
        }
        finally {
            this.writeLock.unlock();
        }
        session.tempSet.clear();
        return true;
    }

    @Override
    public void rollback(Session session) {
        this.writeLock.lock();
        try {
            session.abortTransaction = false;
            session.transactionEndSCN = session.actionSCN = this.getNextSystemChangeNumber();
            this.rollbackPartial(session, 0, session.transactionSCN);
            this.endTransaction(session);
            session.logSequences();
            session.isTransaction = false;
            this.endTransactionTPL(session);
            session.sessionData.newLobFloor = -1L;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void rollbackSavepoint(Session session, int n) {
        long l = session.sessionContext.savepointTimestamps.get(n);
        Integer n2 = session.sessionContext.savepoints.get(n);
        int n3 = n2;
        while (session.sessionContext.savepoints.size() > n + 1) {
            session.sessionContext.savepoints.removeEntry(session.sessionContext.savepoints.size() - 1);
            session.sessionContext.savepointTimestamps.removeLast();
        }
        this.rollbackPartial(session, n3, l);
    }

    @Override
    public void rollbackAction(Session session) {
        this.rollbackPartial(session, session.actionIndex, session.actionStartSCN);
        this.endActionTPL(session);
    }

    @Override
    public void rollbackPartial(Session session, int n, long l) {
        int n2 = session.rowActionList.size();
        if (n == n2) {
            return;
        }
        for (int i = n2 - 1; i >= n; --i) {
            RowAction rowAction = session.rowActionList.get(i);
            if (rowAction == null || rowAction.type == 0 || rowAction.type == 3) continue;
            Row row = rowAction.memoryRow;
            if (row == null) {
                row = (Row)rowAction.store.get(rowAction.getPos(), false);
            }
            if (row == null) continue;
            rowAction.rollback(session, l);
            int n3 = rowAction.mergeRollback(session, l);
            rowAction.store.rollbackRow(session, row, n3, this.txModel);
        }
        session.rowActionList.setSize(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RowAction addDeleteAction(Session session, Table table, PersistentStore persistentStore, Row row, int[] nArray) {
        RowAction rowAction;
        Row row2 = row;
        synchronized (row2) {
            rowAction = RowAction.addDeleteAction(session, table, persistentStore, row, nArray);
        }
        persistentStore.delete(session, row);
        row.rowAction = null;
        if (table.persistenceScope == 20) {
            return rowAction;
        }
        session.rowActionList.add(rowAction);
        return rowAction;
    }

    @Override
    public void addInsertAction(Session session, Table table, PersistentStore persistentStore, Row row, int[] nArray) {
        RowAction rowAction = row.rowAction;
        if (rowAction == null) {
            throw Error.runtimeError(458, "null insert action ");
        }
        persistentStore.indexRow(session, row);
        row.rowAction = null;
        if (table.persistenceScope == 20) {
            return;
        }
        session.rowActionList.add(rowAction);
    }

    @Override
    public void beginTransaction(Session session) {
        if (!session.isTransaction) {
            this.beginTransactionCommon(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beginAction(Session session, Statement statement) {
        this.writeLock.lock();
        try {
            if (this.hasExpired) {
                session.redoAction = true;
                return;
            }
            boolean bl = this.setWaitedSessionsTPL(session, statement);
            if (bl) {
                if (!session.isTransaction) {
                    session.isPreTransaction = true;
                }
                if (session.tempSet.isEmpty()) {
                    this.lockTablesTPL(session, statement);
                } else {
                    this.setWaitingSessionTPL(session);
                }
            } else {
                session.abortTransaction = true;
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void beginActionResume(Session session) {
        Statement statement = session.sessionContext.currentStatement;
        statement = this.updateCurrentStatement(session, statement);
        if (session.sessionContext.invalidStatement) {
            return;
        }
        if (session.isTransaction) {
            session.actionStartSCN = session.actionSCN = this.getNextSystemChangeNumber();
        } else {
            this.beginTransactionCommon(session);
        }
    }

    public void removeTransactionInfo(long l) {
    }

    @Override
    public void resetSession(Session session, Session session2, long l, int n) {
        super.resetSession(session, session2, l, n);
    }

    private void endTransaction(Session session) {
        if (session.isTransaction) {
            this.transactionCount.decrementAndGet();
        }
    }
}

