# - Config file for the rocjpeg package
# It defines the following variables
#  use rocjpeg_INCLUDE_DIR   - include directory for rocjpeg
#  use rocjpeg_LIB_DIR       - library directory for rocjpeg
#  use rocjpeg_LIBRARY       - library to link against
#  use rocjpeg_LIBRARIES     - library to link against

# compute paths
get_filename_component(rocjpeg_CMAKE_DIR "${CMAKE_CURRENT_LIST_FILE}" PATH)

# version
include(${CMAKE_CURRENT_LIST_DIR}/rocjpeg-config-version.cmake)
set(rocjpeg_VERSION ${PACKAGE_VERSION})

# targets
include(${CMAKE_CURRENT_LIST_DIR}/rocjpeg-targets.cmake)


####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was rocjpeg-config.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

set_and_check(rocjpeg_INCLUDE_DIR "${PACKAGE_PREFIX_DIR}/include")
set_and_check(rocjpeg_LIB_DIR "${PACKAGE_PREFIX_DIR}/lib")
set_and_check(rocjpeg_LIBRARY "${PACKAGE_PREFIX_DIR}/lib/librocjpeg.so")
set_and_check(rocjpeg_LIBRARIES "${PACKAGE_PREFIX_DIR}/lib/librocjpeg.so")

if(NOT TARGET rocjpeg::rocjpeg)
  add_library(rocjpeg::rocjpeg INTERFACE IMPORTED)
  set_target_properties(rocjpeg::rocjpeg PROPERTIES INTERFACE_LINK_LIBRARIES ${rocjpeg_LIBRARY})
endif ()

include(FindPackageHandleStandardArgs)
find_package_handle_standard_args(
    rocjpeg
    FOUND_VAR rocjpeg_FOUND
    REQUIRED_VARS rocjpeg_INCLUDE_DIR rocjpeg_LIB_DIR rocjpeg_LIBRARY rocjpeg_LIBRARIES
    VERSION_VAR rocjpeg_VERSION
    HANDLE_COMPONENTS)

