/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.codeinsight;

import com.intellij.json.JsonBundle;
import com.intellij.json.JsonDialectUtil;
import com.intellij.json.codeinsight.JsonLiteralChecker;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;

public class StandardJsonLiteralChecker
implements JsonLiteralChecker {
    public static final Pattern VALID_ESCAPE = Pattern.compile("\\\\([\"\\\\/bfnrt]|u[0-9a-fA-F]{4})");
    private static final Pattern VALID_NUMBER_LITERAL = Pattern.compile("-?(0|[1-9][0-9]*)(\\.[0-9]+)?([eE][+-]?[0-9]+)?");
    public static final String INF = "Infinity";
    public static final String MINUS_INF = "-Infinity";
    public static final String NAN = "NaN";

    @Override
    @Nullable
    public String getErrorForNumericLiteral(String literalText) {
        if (!(INF.equals(literalText) || MINUS_INF.equals(literalText) || NAN.equals(literalText) || VALID_NUMBER_LITERAL.matcher(literalText).matches())) {
            return JsonBundle.message("syntax.error.illegal.floating.point.literal", new Object[0]);
        }
        return null;
    }

    @Override
    @Nullable
    public Pair<TextRange, String> getErrorForStringFragment(Pair<TextRange, String> fragment, JsonStringLiteral stringLiteral) {
        String error;
        String text;
        if (((String)fragment.getSecond()).chars().anyMatch(c -> c <= 31) && new TextRange(0, (text = stringLiteral.getText()).length()).contains((TextRange)fragment.first)) {
            int startOffset = ((TextRange)fragment.first).getStartOffset();
            String part = text.substring(startOffset, ((TextRange)fragment.first).getEndOffset());
            char[] array = part.toCharArray();
            for (int i = 0; i < array.length; ++i) {
                char c2 = array[i];
                if (c2 > '\u001f') continue;
                return Pair.create((Object)new TextRange(startOffset + i, startOffset + i + 1), (Object)JsonBundle.message("syntax.error.control.char.in.string", "\\u" + Integer.toHexString(c2 | 0x10000).substring(1)));
            }
        }
        return (error = StandardJsonLiteralChecker.getStringError((String)fragment.second)) == null ? null : Pair.create((Object)((TextRange)fragment.first), (Object)error);
    }

    @Nullable
    public static String getStringError(String fragmentText) {
        if (fragmentText.startsWith("\\") && fragmentText.length() > 1 && !VALID_ESCAPE.matcher(fragmentText).matches()) {
            if (fragmentText.startsWith("\\u")) {
                return JsonBundle.message("syntax.error.illegal.unicode.escape.sequence", new Object[0]);
            }
            return JsonBundle.message("syntax.error.illegal.escape.sequence", new Object[0]);
        }
        return null;
    }

    @Override
    public boolean isApplicable(PsiElement element) {
        return JsonDialectUtil.isStandardJson(element);
    }
}

