/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto;

import com.intellij.debugger.engine.MethodFilter;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointersKt;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.Range;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinIcons;
import org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto.KotlinLambdaAsyncMethodFilter;
import org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto.KotlinLambdaInfo;
import org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto.KotlinLambdaMethodFilter;
import org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto.KotlinMethodSmartStepTargetKt;
import org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto.KotlinSmartStepTarget;
import org.jetbrains.kotlin.psi.KtFunction;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/KotlinLambdaSmartStepTarget;", "Lorg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/KotlinSmartStepTarget;", "highlightElement", "Lorg/jetbrains/kotlin/psi/KtFunction;", "element", "Lcom/intellij/psi/PsiElement;", "lines", "Lcom/intellij/util/Range;", "", "lambdaInfo", "Lorg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/KotlinLambdaInfo;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtFunction;Lcom/intellij/psi/PsiElement;Lcom/intellij/util/Range;Lorg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/KotlinLambdaInfo;)V", "elementPtr", "Lcom/intellij/psi/SmartPsiElementPointer;", "createMethodFilter", "Lcom/intellij/debugger/engine/MethodFilter;", "getIcon", "Ljavax/swing/Icon;", "kotlin.jvm-debugger.core"})
public final class KotlinLambdaSmartStepTarget
extends KotlinSmartStepTarget {
    @NotNull
    private final KotlinLambdaInfo lambdaInfo;
    @NotNull
    private final SmartPsiElementPointer<PsiElement> elementPtr;

    public KotlinLambdaSmartStepTarget(@NotNull KtFunction highlightElement, @NotNull PsiElement element, @NotNull Range<Integer> lines, @NotNull KotlinLambdaInfo lambdaInfo) {
        Intrinsics.checkNotNullParameter((Object)highlightElement, (String)"highlightElement");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter(lines, (String)"lines");
        Intrinsics.checkNotNullParameter((Object)lambdaInfo, (String)"lambdaInfo");
        super(lambdaInfo.getLabel(), (PsiElement)highlightElement, true, lines);
        this.lambdaInfo = lambdaInfo;
        this.elementPtr = SmartPointersKt.createSmartPointer((PsiElement)element);
    }

    @Override
    @NotNull
    public MethodFilter createMethodFilter() {
        PsiElement psiElement = this.getHighlightElement();
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFunction");
        KotlinLambdaMethodFilter lambdaMethodFilter = new KotlinLambdaMethodFilter((KtFunction)psiElement, (Range<Integer>)this.getCallingExpressionLines(), this.lambdaInfo);
        if (!this.lambdaInfo.getCallerMethodInfo().isInline() && !this.lambdaInfo.isSamSuspendMethod() && Registry.Companion.get("debugger.async.smart.step.into").asBoolean()) {
            PsiElement element = KotlinMethodSmartStepTargetKt.getElementInReadAction(this.elementPtr);
            return new KotlinLambdaAsyncMethodFilter(element, (Range<Integer>)this.getCallingExpressionLines(), this.lambdaInfo, lambdaMethodFilter);
        }
        return (MethodFilter)lambdaMethodFilter;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon2 = KotlinIcons.LAMBDA;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"LAMBDA");
        return icon2;
    }
}

