/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.PrintWriter;
import java.util.Objects;
import org.openstreetmap.josm.io.OsmWriter;

public class OsmWriterFactory {
    private static volatile OsmWriterFactory theFactory;

    public static OsmWriter createOsmWriter(PrintWriter out, boolean osmConform, String version) {
        if (theFactory == null) {
            theFactory = new OsmWriterFactory();
        }
        return theFactory.createOsmWriterImpl(out, osmConform, version);
    }

    public static void setDefaultFactory(OsmWriterFactory factory) {
        theFactory = Objects.requireNonNull(factory);
    }

    protected OsmWriter createOsmWriterImpl(PrintWriter out, boolean osmConform, String version) {
        return new OsmWriter(out, osmConform, version);
    }
}

