"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _object = _interopRequireDefault(require("object.assign"));
var _react = _interopRequireDefault(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _server = _interopRequireDefault(require("react-dom/server"));
var _shallow = _interopRequireDefault(require("react-test-renderer/shallow"));
var _package = require("react-test-renderer/package.json");
var _testUtils = _interopRequireDefault(require("react-dom/test-utils"));
var _semver = _interopRequireDefault(require("semver"));
var _checkPropTypes2 = _interopRequireDefault(require("prop-types/checkPropTypes"));
var _has = _interopRequireDefault(require("has"));
var _reactIs = require("react-is");
var _enzyme = require("enzyme");
var _Utils = require("enzyme/build/Utils");
var _enzymeShallowEqual = _interopRequireDefault(require("enzyme-shallow-equal"));
var _enzymeAdapterUtils = require("enzyme-adapter-utils");
var _findCurrentFiberUsingSlowPath = _interopRequireDefault(require("./findCurrentFiberUsingSlowPath"));
var _detectFiberTags = _interopRequireDefault(require("./detectFiberTags"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }
function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }
function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }
function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }
var is164 = !!_testUtils["default"].Simulate.touchStart; // 16.4+
var is165 = !!_testUtils["default"].Simulate.auxClick; // 16.5+
var is166 = is165 && !_react["default"].unstable_AsyncMode; // 16.6+
var is168 = is166 && typeof _testUtils["default"].act === 'function';
var hasShouldComponentUpdateBug = _semver["default"].satisfies(_package.version, '< 16.8');

// Lazily populated if DOM is available.
var FiberTags = null;
function nodeAndSiblingsArray(nodeWithSibling) {
  var array = [];
  var node = nodeWithSibling;
  while (node != null) {
    array.push(node);
    node = node.sibling;
  }
  return array;
}
function flatten(arr) {
  var result = [];
  var stack = [{
    i: 0,
    array: arr
  }];
  while (stack.length) {
    var n = stack.pop();
    while (n.i < n.array.length) {
      var el = n.array[n.i];
      n.i += 1;
      if (Array.isArray(el)) {
        stack.push(n);
        stack.push({
          i: 0,
          array: el
        });
        break;
      }
      result.push(el);
    }
  }
  return result;
}
function nodeTypeFromType(type) {
  if (type === _reactIs.Portal) {
    return 'portal';
  }
  return (0, _enzymeAdapterUtils.nodeTypeFromType)(type);
}
function isMemo(type) {
  return (0, _enzymeAdapterUtils.compareNodeTypeOf)(type, _reactIs.Memo);
}
function isLazy(type) {
  return (0, _enzymeAdapterUtils.compareNodeTypeOf)(type, _reactIs.Lazy);
}
function unmemoType(type) {
  return isMemo(type) ? type.type : type;
}
function transformSuspense(renderedEl, prerenderEl, _ref) {
  var suspenseFallback = _ref.suspenseFallback;
  if (!(0, _reactIs.isSuspense)(renderedEl)) {
    return renderedEl;
  }
  var children = renderedEl.props.children;
  if (suspenseFallback) {
    var fallback = renderedEl.props.fallback;
    children = replaceLazyWithFallback(children, fallback);
  }
  var _renderedEl$type = renderedEl.type,
    propTypes = _renderedEl$type.propTypes,
    defaultProps = _renderedEl$type.defaultProps,
    contextTypes = _renderedEl$type.contextTypes,
    contextType = _renderedEl$type.contextType,
    childContextTypes = _renderedEl$type.childContextTypes;
  var FakeSuspense = (0, _object["default"])(isStateful(prerenderEl.type) ? /*#__PURE__*/function (_prerenderEl$type) {
    _inherits(FakeSuspense, _prerenderEl$type);
    var _super = _createSuper(FakeSuspense);
    function FakeSuspense() {
      _classCallCheck(this, FakeSuspense);
      return _super.apply(this, arguments);
    }
    _createClass(FakeSuspense, [{
      key: "render",
      value: function render() {
        var type = prerenderEl.type,
          props = prerenderEl.props;
        return /*#__PURE__*/_react["default"].createElement(type, _objectSpread(_objectSpread({}, props), this.props), children);
      }
    }]);
    return FakeSuspense;
  }(prerenderEl.type) : function FakeSuspense(props) {
    // eslint-disable-line prefer-arrow-callback
    return /*#__PURE__*/_react["default"].createElement(renderedEl.type, _objectSpread(_objectSpread({}, renderedEl.props), props), children);
  }, {
    propTypes: propTypes,
    defaultProps: defaultProps,
    contextTypes: contextTypes,
    contextType: contextType,
    childContextTypes: childContextTypes
  });
  return /*#__PURE__*/_react["default"].createElement(FakeSuspense, null, children);
}
function elementToTree(el) {
  if (!(0, _reactIs.isPortal)(el)) {
    return (0, _enzymeAdapterUtils.elementToTree)(el, elementToTree);
  }
  var children = el.children,
    containerInfo = el.containerInfo;
  var props = {
    children: children,
    containerInfo: containerInfo
  };
  return {
    nodeType: 'portal',
    type: _reactIs.Portal,
    props: props,
    key: (0, _enzymeAdapterUtils.ensureKeyOrUndefined)(el.key),
    ref: el.ref || null,
    instance: null,
    rendered: elementToTree(el.children)
  };
}
function _toTree(vnode) {
  if (vnode == null) {
    return null;
  }
  // TODO(lmr): I'm not really sure I understand whether or not this is what
  // i should be doing, or if this is a hack for something i'm doing wrong
  // somewhere else. Should talk to sebastian about this perhaps
  var node = (0, _findCurrentFiberUsingSlowPath["default"])(vnode);
  switch (node.tag) {
    case FiberTags.HostRoot:
      return childrenToTree(node.child);
    case FiberTags.HostPortal:
      {
        var containerInfo = node.stateNode.containerInfo,
          children = node.memoizedProps;
        var props = {
          containerInfo: containerInfo,
          children: children
        };
        return {
          nodeType: 'portal',
          type: _reactIs.Portal,
          props: props,
          key: (0, _enzymeAdapterUtils.ensureKeyOrUndefined)(node.key),
          ref: node.ref,
          instance: null,
          rendered: childrenToTree(node.child)
        };
      }
    case FiberTags.ClassComponent:
      return {
        nodeType: 'class',
        type: node.type,
        props: _objectSpread({}, node.memoizedProps),
        key: (0, _enzymeAdapterUtils.ensureKeyOrUndefined)(node.key),
        ref: node.ref,
        instance: node.stateNode,
        rendered: childrenToTree(node.child)
      };
    case FiberTags.FunctionalComponent:
      return {
        nodeType: 'function',
        type: node.type,
        props: _objectSpread({}, node.memoizedProps),
        key: (0, _enzymeAdapterUtils.ensureKeyOrUndefined)(node.key),
        ref: node.ref,
        instance: null,
        rendered: childrenToTree(node.child)
      };
    case FiberTags.MemoClass:
      return {
        nodeType: 'class',
        type: node.elementType.type,
        props: _objectSpread({}, node.memoizedProps),
        key: (0, _enzymeAdapterUtils.ensureKeyOrUndefined)(node.key),
        ref: node.ref,
        instance: node.stateNode,
        rendered: childrenToTree(node.child.child)
      };
    case FiberTags.MemoSFC:
      {
        var renderedNodes = flatten(nodeAndSiblingsArray(node.child).map(_toTree));
        if (renderedNodes.length === 0) {
          renderedNodes = childrenToTree(node.memoizedProps.children);
        }
        return {
          nodeType: 'function',
          type: node.elementType,
          props: _objectSpread({}, node.memoizedProps),
          key: (0, _enzymeAdapterUtils.ensureKeyOrUndefined)(node.key),
          ref: node.ref,
          instance: null,
          rendered: renderedNodes
        };
      }
    case FiberTags.HostComponent:
      {
        var _renderedNodes = flatten(nodeAndSiblingsArray(node.child).map(_toTree));
        if (_renderedNodes.length === 0) {
          _renderedNodes = [node.memoizedProps.children];
        }
        return {
          nodeType: 'host',
          type: node.type,
          props: _objectSpread({}, node.memoizedProps),
          key: (0, _enzymeAdapterUtils.ensureKeyOrUndefined)(node.key),
          ref: node.ref,
          instance: node.stateNode,
          rendered: _renderedNodes
        };
      }
    case FiberTags.HostText:
      return node.memoizedProps;
    case FiberTags.Fragment:
    case FiberTags.Mode:
    case FiberTags.ContextProvider:
    case FiberTags.ContextConsumer:
      return childrenToTree(node.child);
    case FiberTags.Profiler:
    case FiberTags.ForwardRef:
      {
        return {
          nodeType: 'function',
          type: node.type,
          props: _objectSpread({}, node.pendingProps),
          key: (0, _enzymeAdapterUtils.ensureKeyOrUndefined)(node.key),
          ref: node.ref,
          instance: null,
          rendered: childrenToTree(node.child)
        };
      }
    case FiberTags.Suspense:
      {
        return {
          nodeType: 'function',
          type: _reactIs.Suspense,
          props: _objectSpread({}, node.memoizedProps),
          key: (0, _enzymeAdapterUtils.ensureKeyOrUndefined)(node.key),
          ref: node.ref,
          instance: null,
          rendered: childrenToTree(node.child)
        };
      }
    case FiberTags.Lazy:
      return childrenToTree(node.child);
    default:
      throw new Error("Enzyme Internal Error: unknown node with tag ".concat(node.tag));
  }
}
function childrenToTree(node) {
  if (!node) {
    return null;
  }
  var children = nodeAndSiblingsArray(node);
  if (children.length === 0) {
    return null;
  }
  if (children.length === 1) {
    return _toTree(children[0]);
  }
  return flatten(children.map(_toTree));
}
function _nodeToHostNode(_node) {
  // NOTE(lmr): node could be a function component
  // which wont have an instance prop, but we can get the
  // host node associated with its return value at that point.
  // Although this breaks down if the return value is an array,
  // as is possible with React 16.
  var node = _node;
  while (node && !Array.isArray(node) && node.instance === null) {
    node = node.rendered;
  }
  // if the SFC returned null effectively, there is no host node.
  if (!node) {
    return null;
  }
  var mapper = function mapper(item) {
    if (item && item.instance) return _reactDom["default"].findDOMNode(item.instance);
    return null;
  };
  if (Array.isArray(node)) {
    return node.map(mapper);
  }
  if (Array.isArray(node.rendered) && node.nodeType === 'class') {
    return node.rendered.map(mapper);
  }
  return mapper(node);
}
function replaceLazyWithFallback(node, fallback) {
  if (!node) {
    return null;
  }
  if (Array.isArray(node)) {
    return node.map(function (el) {
      return replaceLazyWithFallback(el, fallback);
    });
  }
  if (isLazy(node.type)) {
    return fallback;
  }
  return _objectSpread(_objectSpread({}, node), {}, {
    props: _objectSpread(_objectSpread({}, node.props), {}, {
      children: replaceLazyWithFallback(node.props.children, fallback)
    })
  });
}
var eventOptions = {
  animation: true,
  pointerEvents: is164,
  auxClick: is165
};
function getEmptyStateValue() {
  // this handles a bug in React 16.0 - 16.2
  // see https://github.com/facebook/react/commit/39be83565c65f9c522150e52375167568a2a1459
  // also see https://github.com/facebook/react/pull/11965
  // eslint-disable-next-line react/prefer-stateless-function
  var EmptyState = /*#__PURE__*/function (_React$Component) {
    _inherits(EmptyState, _React$Component);
    var _super2 = _createSuper(EmptyState);
    function EmptyState() {
      _classCallCheck(this, EmptyState);
      return _super2.apply(this, arguments);
    }
    _createClass(EmptyState, [{
      key: "render",
      value: function render() {
        return null;
      }
    }]);
    return EmptyState;
  }(_react["default"].Component);
  var testRenderer = new _shallow["default"]();
  testRenderer.render( /*#__PURE__*/_react["default"].createElement(EmptyState));
  return testRenderer._instance.state;
}
function wrapAct(fn) {
  if (!is168) {
    return fn();
  }
  var returnVal;
  _testUtils["default"].act(function () {
    returnVal = fn();
  });
  return returnVal;
}
function getProviderDefaultValue(Provider) {
  // React stores references to the Provider's defaultValue differently across versions.
  if ('_defaultValue' in Provider._context) {
    return Provider._context._defaultValue;
  }
  if ('_currentValue' in Provider._context) {
    return Provider._context._currentValue;
  }
  throw new Error('Enzyme Internal Error: can’t figure out how to get Provider’s default value');
}
function makeFakeElement(type) {
  return {
    $$typeof: _reactIs.Element,
    type: type
  };
}
function isStateful(Component) {
  return Component.prototype && (Component.prototype.isReactComponent || Array.isArray(Component.__reactAutoBindPairs) // fallback for createClass components
  );
}
var ReactSixteenAdapter = /*#__PURE__*/function (_EnzymeAdapter) {
  _inherits(ReactSixteenAdapter, _EnzymeAdapter);
  var _super3 = _createSuper(ReactSixteenAdapter);
  function ReactSixteenAdapter() {
    var _this;
    _classCallCheck(this, ReactSixteenAdapter);
    _this = _super3.call(this);
    var lifecycles = _this.options.lifecycles;
    _this.options = _objectSpread(_objectSpread({}, _this.options), {}, {
      enableComponentDidUpdateOnSetState: true,
      // TODO: remove, semver-major
      legacyContextMode: 'parent',
      lifecycles: _objectSpread(_objectSpread({}, lifecycles), {}, {
        componentDidUpdate: {
          onSetState: true
        },
        getDerivedStateFromProps: {
          hasShouldComponentUpdateBug: hasShouldComponentUpdateBug
        },
        getSnapshotBeforeUpdate: true,
        setState: {
          skipsComponentDidUpdateOnNullish: true
        },
        getChildContext: {
          calledByRenderer: false
        },
        getDerivedStateFromError: is166
      })
    });
    return _this;
  }
  _createClass(ReactSixteenAdapter, [{
    key: "createMountRenderer",
    value: function createMountRenderer(options) {
      (0, _enzymeAdapterUtils.assertDomAvailable)('mount');
      if ((0, _has["default"])(options, 'suspenseFallback')) {
        throw new TypeError('`suspenseFallback` is not supported by the `mount` renderer');
      }
      if (FiberTags === null) {
        // Requires DOM.
        FiberTags = (0, _detectFiberTags["default"])();
      }
      var attachTo = options.attachTo,
        hydrateIn = options.hydrateIn,
        wrappingComponentProps = options.wrappingComponentProps;
      var domNode = hydrateIn || attachTo || global.document.createElement('div');
      var instance = null;
      var adapter = this;
      return _objectSpread({
        render: function render(el, context, callback) {
          return wrapAct(function () {
            if (instance === null) {
              var type = el.type,
                props = el.props,
                ref = el.ref;
              var wrapperProps = _objectSpread({
                Component: type,
                props: props,
                wrappingComponentProps: wrappingComponentProps,
                context: context
              }, ref && {
                refProp: ref
              });
              var ReactWrapperComponent = (0, _enzymeAdapterUtils.createMountWrapper)(el, _objectSpread(_objectSpread({}, options), {}, {
                adapter: adapter
              }));
              var wrappedEl = /*#__PURE__*/_react["default"].createElement(ReactWrapperComponent, wrapperProps);
              instance = hydrateIn ? _reactDom["default"].hydrate(wrappedEl, domNode) : _reactDom["default"].render(wrappedEl, domNode);
              if (typeof callback === 'function') {
                callback();
              }
            } else {
              instance.setChildProps(el.props, context, callback);
            }
          });
        },
        unmount: function unmount() {
          _reactDom["default"].unmountComponentAtNode(domNode);
          instance = null;
        },
        getNode: function getNode() {
          if (!instance) {
            return null;
          }
          return (0, _enzymeAdapterUtils.getNodeFromRootFinder)(adapter.isCustomComponent, _toTree(instance._reactInternalFiber), options);
        },
        simulateError: function simulateError(nodeHierarchy, rootNode, error) {
          var isErrorBoundary = function isErrorBoundary(_ref2) {
            var elInstance = _ref2.instance,
              type = _ref2.type;
            if (is166 && type && type.getDerivedStateFromError) {
              return true;
            }
            return elInstance && elInstance.componentDidCatch;
          };
          var _ref3 = nodeHierarchy.find(isErrorBoundary) || {},
            catchingInstance = _ref3.instance,
            catchingType = _ref3.type;
          (0, _enzymeAdapterUtils.simulateError)(error, catchingInstance, rootNode, nodeHierarchy, nodeTypeFromType, adapter.displayNameOfNode.bind(adapter), is166 ? catchingType : undefined);
        },
        simulateEvent: function simulateEvent(node, event, mock) {
          var mappedEvent = (0, _enzymeAdapterUtils.mapNativeEventNames)(event, eventOptions);
          var eventFn = _testUtils["default"].Simulate[mappedEvent];
          if (!eventFn) {
            throw new TypeError("ReactWrapper::simulate() event '".concat(event, "' does not exist"));
          }
          wrapAct(function () {
            eventFn(adapter.nodeToHostNode(node), mock);
          });
        },
        batchedUpdates: function batchedUpdates(fn) {
          return fn();
          // return ReactDOM.unstable_batchedUpdates(fn);
        },
        getWrappingComponentRenderer: function getWrappingComponentRenderer() {
          return _objectSpread(_objectSpread({}, this), (0, _enzymeAdapterUtils.getWrappingComponentMountRenderer)({
            toTree: function toTree(inst) {
              return _toTree(inst._reactInternalFiber);
            },
            getMountWrapperInstance: function getMountWrapperInstance() {
              return instance;
            }
          }));
        }
      }, is168 && {
        wrapInvoke: wrapAct
      });
    }
  }, {
    key: "createShallowRenderer",
    value: function createShallowRenderer() {
      var _this2 = this;
      var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      var adapter = this;
      var renderer = new _shallow["default"]();
      var suspenseFallback = options.suspenseFallback;
      if (typeof suspenseFallback !== 'undefined' && typeof suspenseFallback !== 'boolean') {
        throw TypeError('`options.suspenseFallback` should be boolean or undefined');
      }
      var isDOM = false;
      var cachedNode = null;
      var lastComponent = null;
      var wrappedComponent = null;
      var sentinel = {};

      // wrap memo components with a PureComponent, or a class component with sCU
      var wrapPureComponent = function wrapPureComponent(Component, compare) {
        if (!is166) {
          throw new RangeError('this function should not be called in React < 16.6. Please report this!');
        }
        if (lastComponent !== Component) {
          if (isStateful(Component)) {
            wrappedComponent = /*#__PURE__*/function (_Component) {
              _inherits(wrappedComponent, _Component);
              var _super4 = _createSuper(wrappedComponent);
              function wrappedComponent() {
                _classCallCheck(this, wrappedComponent);
                return _super4.apply(this, arguments);
              }
              return _createClass(wrappedComponent);
            }(Component); // eslint-disable-line react/prefer-stateless-function
            if (compare) {
              wrappedComponent.prototype.shouldComponentUpdate = function (nextProps) {
                return !compare(_this2.props, nextProps);
              };
            } else {
              wrappedComponent.prototype.isPureReactComponent = true;
            }
          } else {
            var memoized = sentinel;
            var prevProps;
            wrappedComponent = function wrappedComponent(props) {
              var shouldUpdate = memoized === sentinel || (compare ? !compare(prevProps, props) : !(0, _enzymeShallowEqual["default"])(prevProps, props));
              if (shouldUpdate) {
                for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
                  args[_key - 1] = arguments[_key];
                }
                memoized = Component.apply(void 0, [_objectSpread(_objectSpread({}, Component.defaultProps), props)].concat(args));
                prevProps = props;
              }
              return memoized;
            };
          }
          (0, _object["default"])(wrappedComponent, Component, {
            displayName: adapter.displayNameOfNode({
              type: Component
            })
          });
          lastComponent = Component;
        }
        return wrappedComponent;
      };

      // Wrap functional components on versions prior to 16.5,
      // to avoid inadvertently pass a `this` instance to it.
      var wrapFunctionalComponent = function wrapFunctionalComponent(Component) {
        if (is166 && (0, _has["default"])(Component, 'defaultProps')) {
          if (lastComponent !== Component) {
            wrappedComponent = (0, _object["default"])(
            // eslint-disable-next-line new-cap
            function (props) {
              for (var _len2 = arguments.length, args = new Array(_len2 > 1 ? _len2 - 1 : 0), _key2 = 1; _key2 < _len2; _key2++) {
                args[_key2 - 1] = arguments[_key2];
              }
              return Component.apply(void 0, [_objectSpread(_objectSpread({}, Component.defaultProps), props)].concat(args));
            }, Component, {
              displayName: adapter.displayNameOfNode({
                type: Component
              })
            });
            lastComponent = Component;
          }
          return wrappedComponent;
        }
        if (is165) {
          return Component;
        }
        if (lastComponent !== Component) {
          wrappedComponent = (0, _object["default"])(function () {
            return Component.apply(void 0, arguments);
          },
          // eslint-disable-line new-cap
          Component);
          lastComponent = Component;
        }
        return wrappedComponent;
      };
      var renderElement = function renderElement(elConfig) {
        for (var _len3 = arguments.length, rest = new Array(_len3 > 1 ? _len3 - 1 : 0), _key3 = 1; _key3 < _len3; _key3++) {
          rest[_key3 - 1] = arguments[_key3];
        }
        var renderedEl = renderer.render.apply(renderer, [elConfig].concat(rest));
        var typeIsExisted = !!(renderedEl && renderedEl.type);
        if (is166 && typeIsExisted) {
          var clonedEl = transformSuspense(renderedEl, elConfig, {
            suspenseFallback: suspenseFallback
          });
          var elementIsChanged = clonedEl.type !== renderedEl.type;
          if (elementIsChanged) {
            return renderer.render.apply(renderer, [_objectSpread(_objectSpread({}, elConfig), {}, {
              type: clonedEl.type
            })].concat(rest));
          }
        }
        return renderedEl;
      };
      return {
        render: function render(el, unmaskedContext) {
          var _ref4 = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {},
            _ref4$providerValues = _ref4.providerValues,
            providerValues = _ref4$providerValues === void 0 ? new Map() : _ref4$providerValues;
          cachedNode = el;
          /* eslint consistent-return: 0 */
          if (typeof el.type === 'string') {
            isDOM = true;
          } else if ((0, _reactIs.isContextProvider)(el)) {
            providerValues.set(el.type, el.props.value);
            var MockProvider = (0, _object["default"])(function (props) {
              return props.children;
            }, el.type);
            return (0, _enzymeAdapterUtils.withSetStateAllowed)(function () {
              return renderElement(_objectSpread(_objectSpread({}, el), {}, {
                type: MockProvider
              }));
            });
          } else if ((0, _reactIs.isContextConsumer)(el)) {
            var Provider = adapter.getProviderFromConsumer(el.type);
            var value = providerValues.has(Provider) ? providerValues.get(Provider) : getProviderDefaultValue(Provider);
            var MockConsumer = (0, _object["default"])(function (props) {
              return props.children(value);
            }, el.type);
            return (0, _enzymeAdapterUtils.withSetStateAllowed)(function () {
              return renderElement(_objectSpread(_objectSpread({}, el), {}, {
                type: MockConsumer
              }));
            });
          } else {
            isDOM = false;
            var renderedEl = el;
            if (isLazy(renderedEl)) {
              throw TypeError('`React.lazy` is not supported by shallow rendering.');
            }
            renderedEl = transformSuspense(renderedEl, renderedEl, {
              suspenseFallback: suspenseFallback
            });
            var _renderedEl = renderedEl,
              Component = _renderedEl.type;
            var context = (0, _enzymeAdapterUtils.getMaskedContext)(Component.contextTypes, unmaskedContext);
            if (isMemo(el.type)) {
              var _el$type = el.type,
                InnerComp = _el$type.type,
                compare = _el$type.compare;
              return (0, _enzymeAdapterUtils.withSetStateAllowed)(function () {
                return renderElement(_objectSpread(_objectSpread({}, el), {}, {
                  type: wrapPureComponent(InnerComp, compare)
                }), context);
              });
            }
            var isComponentStateful = isStateful(Component);
            if (!isComponentStateful && typeof Component === 'function') {
              return (0, _enzymeAdapterUtils.withSetStateAllowed)(function () {
                return renderElement(_objectSpread(_objectSpread({}, renderedEl), {}, {
                  type: wrapFunctionalComponent(Component)
                }), context);
              });
            }
            if (isComponentStateful) {
              if (renderer._instance && el.props === renderer._instance.props && !(0, _enzymeShallowEqual["default"])(context, renderer._instance.context)) {
                var _spyMethod = (0, _enzymeAdapterUtils.spyMethod)(renderer, '_updateClassComponent', function (originalMethod) {
                    return function _updateClassComponent() {
                      var props = renderer._instance.props;
                      var clonedProps = _objectSpread({}, props);
                      renderer._instance.props = clonedProps;
                      for (var _len4 = arguments.length, args = new Array(_len4), _key4 = 0; _key4 < _len4; _key4++) {
                        args[_key4] = arguments[_key4];
                      }
                      var result = originalMethod.apply(renderer, args);
                      renderer._instance.props = props;
                      restore();
                      return result;
                    };
                  }),
                  restore = _spyMethod.restore;
              }

              // fix react bug; see implementation of `getEmptyStateValue`
              var emptyStateValue = getEmptyStateValue();
              if (emptyStateValue) {
                Object.defineProperty(Component.prototype, 'state', {
                  configurable: true,
                  enumerable: true,
                  get: function get() {
                    return null;
                  },
                  set: function set(value) {
                    if (value !== emptyStateValue) {
                      Object.defineProperty(this, 'state', {
                        configurable: true,
                        enumerable: true,
                        value: value,
                        writable: true
                      });
                    }
                  }
                });
              }
            }
            return (0, _enzymeAdapterUtils.withSetStateAllowed)(function () {
              return renderElement(renderedEl, context);
            });
          }
        },
        unmount: function unmount() {
          renderer.unmount();
        },
        getNode: function getNode() {
          if (isDOM) {
            return elementToTree(cachedNode);
          }
          var output = renderer.getRenderOutput();
          return {
            nodeType: nodeTypeFromType(cachedNode.type),
            type: cachedNode.type,
            props: cachedNode.props,
            key: (0, _enzymeAdapterUtils.ensureKeyOrUndefined)(cachedNode.key),
            ref: cachedNode.ref,
            instance: renderer._instance,
            rendered: Array.isArray(output) ? flatten(output).map(function (el) {
              return elementToTree(el);
            }) : elementToTree(output)
          };
        },
        simulateError: function simulateError(nodeHierarchy, rootNode, error) {
          (0, _enzymeAdapterUtils.simulateError)(error, renderer._instance, cachedNode, nodeHierarchy.concat(cachedNode), nodeTypeFromType, adapter.displayNameOfNode.bind(adapter), is166 ? cachedNode.type : undefined);
        },
        simulateEvent: function simulateEvent(node, event) {
          for (var _len5 = arguments.length, args = new Array(_len5 > 2 ? _len5 - 2 : 0), _key5 = 2; _key5 < _len5; _key5++) {
            args[_key5 - 2] = arguments[_key5];
          }
          var handler = node.props[(0, _enzymeAdapterUtils.propFromEvent)(event, eventOptions)];
          if (handler) {
            (0, _enzymeAdapterUtils.withSetStateAllowed)(function () {
              // TODO(lmr): create/use synthetic events
              // TODO(lmr): emulate React's event propagation
              // ReactDOM.unstable_batchedUpdates(() => {
              handler.apply(void 0, args);
              // });
            });
          }
        },
        batchedUpdates: function batchedUpdates(fn) {
          return fn();
          // return ReactDOM.unstable_batchedUpdates(fn);
        },
        checkPropTypes: function checkPropTypes(typeSpecs, values, location, hierarchy) {
          return (0, _checkPropTypes2["default"])(typeSpecs, values, location, (0, _enzymeAdapterUtils.displayNameOfNode)(cachedNode), function () {
            return (0, _enzymeAdapterUtils.getComponentStack)(hierarchy.concat([cachedNode]));
          });
        }
      };
    }
  }, {
    key: "createStringRenderer",
    value: function createStringRenderer(options) {
      if ((0, _has["default"])(options, 'suspenseFallback')) {
        throw new TypeError('`suspenseFallback` should not be specified in options of string renderer');
      }
      return {
        render: function render(el, context) {
          if (options.context && (el.type.contextTypes || options.childContextTypes)) {
            var childContextTypes = _objectSpread(_objectSpread({}, el.type.contextTypes || {}), options.childContextTypes);
            var ContextWrapper = (0, _enzymeAdapterUtils.createRenderWrapper)(el, context, childContextTypes);
            return _server["default"].renderToStaticMarkup( /*#__PURE__*/_react["default"].createElement(ContextWrapper));
          }
          return _server["default"].renderToStaticMarkup(el);
        }
      };
    }

    // Provided a bag of options, return an `EnzymeRenderer`. Some options can be implementation
    // specific, like `attach` etc. for React, but not part of this interface explicitly.
    // eslint-disable-next-line class-methods-use-this
  }, {
    key: "createRenderer",
    value: function createRenderer(options) {
      switch (options.mode) {
        case _enzyme.EnzymeAdapter.MODES.MOUNT:
          return this.createMountRenderer(options);
        case _enzyme.EnzymeAdapter.MODES.SHALLOW:
          return this.createShallowRenderer(options);
        case _enzyme.EnzymeAdapter.MODES.STRING:
          return this.createStringRenderer(options);
        default:
          throw new Error("Enzyme Internal Error: Unrecognized mode: ".concat(options.mode));
      }
    }
  }, {
    key: "wrap",
    value: function wrap(element) {
      return (0, _enzymeAdapterUtils.wrap)(element);
    }

    // converts an RSTNode to the corresponding JSX Pragma Element. This will be needed
    // in order to implement the `Wrapper.mount()` and `Wrapper.shallow()` methods, but should
    // be pretty straightforward for people to implement.
    // eslint-disable-next-line class-methods-use-this
  }, {
    key: "nodeToElement",
    value: function nodeToElement(node) {
      if (!node || _typeof(node) !== 'object') return null;
      var type = node.type;
      return /*#__PURE__*/_react["default"].createElement(unmemoType(type), (0, _enzymeAdapterUtils.propsWithKeysAndRef)(node));
    }

    // eslint-disable-next-line class-methods-use-this
  }, {
    key: "matchesElementType",
    value: function matchesElementType(node, matchingType) {
      if (!node) {
        return node;
      }
      var type = node.type;
      return unmemoType(type) === unmemoType(matchingType);
    }
  }, {
    key: "elementToNode",
    value: function elementToNode(element) {
      return elementToTree(element);
    }
  }, {
    key: "nodeToHostNode",
    value: function nodeToHostNode(node) {
      var supportsArray = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
      var nodes = _nodeToHostNode(node);
      if (Array.isArray(nodes) && !supportsArray) {
        return nodes[0];
      }
      return nodes;
    }
  }, {
    key: "displayNameOfNode",
    value: function displayNameOfNode(node) {
      if (!node) return null;
      var type = node.type,
        $$typeof = node.$$typeof;
      var adapter = this;
      var nodeType = type || $$typeof;

      // newer node types may be undefined, so only test if the nodeType exists
      if (nodeType) {
        switch (nodeType) {
          case (is166 ? _reactIs.ConcurrentMode : _reactIs.AsyncMode) || NaN:
            return is166 ? 'ConcurrentMode' : 'AsyncMode';
          case _reactIs.Fragment || NaN:
            return 'Fragment';
          case _reactIs.StrictMode || NaN:
            return 'StrictMode';
          case _reactIs.Profiler || NaN:
            return 'Profiler';
          case _reactIs.Portal || NaN:
            return 'Portal';
          case _reactIs.Suspense || NaN:
            return 'Suspense';
          default:
        }
      }
      var $$typeofType = type && type.$$typeof;
      switch ($$typeofType) {
        case _reactIs.ContextConsumer || NaN:
          return 'ContextConsumer';
        case _reactIs.ContextProvider || NaN:
          return 'ContextProvider';
        case _reactIs.Memo || NaN:
          {
            var nodeName = (0, _enzymeAdapterUtils.displayNameOfNode)(node);
            return typeof nodeName === 'string' ? nodeName : "Memo(".concat(adapter.displayNameOfNode(type), ")");
          }
        case _reactIs.ForwardRef || NaN:
          {
            if (type.displayName) {
              return type.displayName;
            }
            var name = adapter.displayNameOfNode({
              type: type.render
            });
            return name ? "ForwardRef(".concat(name, ")") : 'ForwardRef';
          }
        case _reactIs.Lazy || NaN:
          {
            return 'lazy';
          }
        default:
          return (0, _enzymeAdapterUtils.displayNameOfNode)(node);
      }
    }
  }, {
    key: "isValidElement",
    value: function isValidElement(element) {
      return (0, _reactIs.isElement)(element);
    }
  }, {
    key: "isValidElementType",
    value: function isValidElementType(object) {
      return !!object && (0, _reactIs.isValidElementType)(object);
    }
  }, {
    key: "isFragment",
    value: function isFragment(fragment) {
      return (0, _Utils.typeOfNode)(fragment) === _reactIs.Fragment;
    }
  }, {
    key: "isCustomComponent",
    value: function isCustomComponent(type) {
      var fakeElement = makeFakeElement(type);
      return !!type && (typeof type === 'function' || (0, _reactIs.isForwardRef)(fakeElement) || (0, _reactIs.isContextProvider)(fakeElement) || (0, _reactIs.isContextConsumer)(fakeElement) || (0, _reactIs.isSuspense)(fakeElement));
    }
  }, {
    key: "isContextConsumer",
    value: function isContextConsumer(type) {
      return !!type && (0, _reactIs.isContextConsumer)(makeFakeElement(type));
    }
  }, {
    key: "isCustomComponentElement",
    value: function isCustomComponentElement(inst) {
      if (!inst || !this.isValidElement(inst)) {
        return false;
      }
      return this.isCustomComponent(inst.type);
    }
  }, {
    key: "getProviderFromConsumer",
    value: function getProviderFromConsumer(Consumer) {
      // React stores references to the Provider on a Consumer differently across versions.
      if (Consumer) {
        var Provider;
        if (Consumer._context) {
          // check this first, to avoid a deprecation warning
          Provider = Consumer._context.Provider;
        } else if (Consumer.Provider) {
          Provider = Consumer.Provider;
        }
        if (Provider) {
          return Provider;
        }
      }
      throw new Error('Enzyme Internal Error: can’t figure out how to get Provider from Consumer');
    }
  }, {
    key: "createElement",
    value: function createElement() {
      return /*#__PURE__*/_react["default"].createElement.apply(_react["default"], arguments);
    }
  }, {
    key: "wrapWithWrappingComponent",
    value: function wrapWithWrappingComponent(node, options) {
      return {
        RootFinder: _enzymeAdapterUtils.RootFinder,
        node: (0, _enzymeAdapterUtils.wrapWithWrappingComponent)(_react["default"].createElement, node, options)
      };
    }
  }]);
  return ReactSixteenAdapter;
}(_enzyme.EnzymeAdapter);
var _default2 = ReactSixteenAdapter;
exports["default"] = _default2;
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
//# sourceMappingURL=ReactSixteenAdapter.js.map