/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.auth.credentials;

import software.amazon.awssdk.crt.auth.credentials.Credentials;
import software.amazon.awssdk.crt.auth.credentials.CredentialsProvider;

public class StaticCredentialsProvider
extends CredentialsProvider {
    private StaticCredentialsProvider(StaticCredentialsProviderBuilder builder) {
        byte[] accessKeyId = builder.getAccessKeyId();
        byte[] secretAccessKey = builder.getSecretAccessKey();
        if (accessKeyId == null || secretAccessKey == null) {
            throw new IllegalArgumentException("StaticCredentialsProvider - accessKeyId and secretAccessKey must be non null");
        }
        byte[] sessionToken = builder.getSessionToken();
        long nativeHandle = StaticCredentialsProvider.staticCredentialsProviderNew(this, accessKeyId, secretAccessKey, sessionToken);
        this.acquireNativeHandle(nativeHandle);
    }

    private static native long staticCredentialsProviderNew(StaticCredentialsProvider var0, byte[] var1, byte[] var2, byte[] var3);

    public static class StaticCredentialsProviderBuilder {
        private byte[] accessKeyId;
        private byte[] secretAccessKey;
        private byte[] sessionToken;

        public StaticCredentialsProviderBuilder withAccessKeyId(byte[] accessKeyId) {
            this.accessKeyId = accessKeyId;
            return this;
        }

        byte[] getAccessKeyId() {
            return this.accessKeyId;
        }

        public StaticCredentialsProviderBuilder withSecretAccessKey(byte[] secretAccessKey) {
            this.secretAccessKey = secretAccessKey;
            return this;
        }

        byte[] getSecretAccessKey() {
            return this.secretAccessKey;
        }

        public StaticCredentialsProviderBuilder withSessionToken(byte[] sessionToken) {
            this.sessionToken = sessionToken;
            return this;
        }

        byte[] getSessionToken() {
            return this.sessionToken;
        }

        public StaticCredentialsProviderBuilder withCredentials(Credentials credentials) {
            this.accessKeyId = credentials.getAccessKeyId();
            this.secretAccessKey = credentials.getSecretAccessKey();
            this.sessionToken = credentials.getSessionToken();
            return this;
        }

        public StaticCredentialsProvider build() {
            return new StaticCredentialsProvider(this);
        }
    }
}

