/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import java.util.List;
import org.scilab.forge.jlatexmath.Atom;
import org.scilab.forge.jlatexmath.Box;
import org.scilab.forge.jlatexmath.DelimiterFactory;
import org.scilab.forge.jlatexmath.Glue;
import org.scilab.forge.jlatexmath.HorizontalBox;
import org.scilab.forge.jlatexmath.MiddleAtom;
import org.scilab.forge.jlatexmath.RowAtom;
import org.scilab.forge.jlatexmath.SpaceAtom;
import org.scilab.forge.jlatexmath.SymbolAtom;
import org.scilab.forge.jlatexmath.TeXEnvironment;
import org.scilab.forge.jlatexmath.TeXFont;

public class FencedAtom
extends Atom {
    private static final int DELIMITER_FACTOR = 901;
    private static final float DELIMITER_SHORTFALL = 5.0f;
    private final Atom base;
    private SymbolAtom left = null;
    private SymbolAtom right = null;
    private final List<MiddleAtom> middle;

    public FencedAtom(Atom base, SymbolAtom l, SymbolAtom r) {
        this(base, l, null, r);
    }

    public FencedAtom(Atom base, SymbolAtom l, List<MiddleAtom> m, SymbolAtom r) {
        this.base = base == null ? new RowAtom() : base;
        if (l == null || !l.getName().equals("normaldot")) {
            this.left = l;
        }
        if (r == null || !r.getName().equals("normaldot")) {
            this.right = r;
        }
        this.middle = m;
    }

    @Override
    public int getLeftType() {
        return 7;
    }

    @Override
    public int getRightType() {
        return 7;
    }

    private static void center(Box box, float axis) {
        float h = box.getHeight();
        float total = h + box.getDepth();
        box.setShift(-(total / 2.0f - h) - axis);
    }

    @Override
    public Box createBox(TeXEnvironment env) {
        TeXFont tf = env.getTeXFont();
        Box content = this.base.createBox(env);
        float shortfall = 5.0f * SpaceAtom.getFactor(3, env);
        float axis = tf.getAxisHeight(env.getStyle());
        float delta = Math.max(content.getHeight() - axis, content.getDepth() + axis);
        float minHeight = Math.max(delta / 500.0f * 901.0f, 2.0f * delta - shortfall);
        HorizontalBox hBox = new HorizontalBox();
        if (this.middle != null) {
            for (int i = 0; i < this.middle.size(); ++i) {
                MiddleAtom at = this.middle.get(i);
                if (!(at.base instanceof SymbolAtom)) continue;
                Box b = DelimiterFactory.create(((SymbolAtom)at.base).getName(), env, minHeight);
                FencedAtom.center(b, axis);
                at.box = b;
            }
            if (this.middle.size() != 0) {
                content = this.base.createBox(env);
            }
        }
        if (this.left != null) {
            Box b = DelimiterFactory.create(this.left.getName(), env, minHeight);
            FencedAtom.center(b, axis);
            hBox.add(b);
        }
        if (!(this.base instanceof SpaceAtom)) {
            hBox.add(Glue.get(4, this.base.getLeftType(), env));
        }
        hBox.add(content);
        if (!(this.base instanceof SpaceAtom)) {
            hBox.add(Glue.get(this.base.getRightType(), 5, env));
        }
        if (this.right != null) {
            Box b = DelimiterFactory.create(this.right.getName(), env, minHeight);
            FencedAtom.center(b, axis);
            hBox.add(b);
        }
        return hBox;
    }
}

